/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core.registry;

import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.savage_and_ravage.common.block.ChiseledGloomyTilesBlock;
import com.teamabnormals.savage_and_ravage.common.block.PottedCreeperSporesBlock;
import com.teamabnormals.savage_and_ravage.common.block.RunedGloomyTilesBlock;
import com.teamabnormals.savage_and_ravage.common.block.SporeBombBlock;
import com.teamabnormals.savage_and_ravage.core.SavageAndRavage;
import com.teamabnormals.savage_and_ravage.core.registry.SRItems;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="savage_and_ravage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SRBlocks {
    public static final BlockSubRegistryHelper HELPER = (BlockSubRegistryHelper)SavageAndRavage.REGISTRY_HELPER.getBlockSubHelper();
    public static final RegistryObject<Block> GLOOMY_TILES = HELPER.createBlock("gloomy_tiles", () -> new Block(SRProperties.GLOOMY_TILES));
    public static final RegistryObject<Block> CHISELED_GLOOMY_TILES = HELPER.createBlock("chiseled_gloomy_tiles", () -> new ChiseledGloomyTilesBlock(SRProperties.LIGHTABLE_GLOOMY_TILES));
    public static final RegistryObject<Block> GLOOMY_TILE_STAIRS = HELPER.createBlock("gloomy_tile_stairs", () -> new StairBlock(() -> ((Block)GLOOMY_TILES.get()).m_49966_(), SRProperties.GLOOMY_TILES));
    public static final RegistryObject<Block> GLOOMY_TILE_WALL = HELPER.createBlock("gloomy_tile_wall", () -> new WallBlock(SRProperties.GLOOMY_TILES));
    public static final RegistryObject<Block> GLOOMY_TILE_SLAB = HELPER.createBlock("gloomy_tile_slab", () -> new SlabBlock(SRProperties.GLOOMY_TILES));
    public static final RegistryObject<Block> RUNED_GLOOMY_TILES = HELPER.createBlock("runed_gloomy_tiles", () -> new RunedGloomyTilesBlock(SRProperties.LIGHTABLE_GLOOMY_TILES));
    public static final RegistryObject<Block> BLAST_PROOF_PLATES = HELPER.createBlock("blast_proof_plates", () -> new Block(SRProperties.BLAST_PROOF_PLATES));
    public static final RegistryObject<Block> BLAST_PROOF_STAIRS = HELPER.createBlock("blast_proof_stairs", () -> new StairBlock(() -> ((Block)BLAST_PROOF_PLATES.get()).m_49966_(), SRProperties.BLAST_PROOF_PLATES));
    public static final RegistryObject<Block> BLAST_PROOF_SLAB = HELPER.createBlock("blast_proof_slab", () -> new SlabBlock(SRProperties.BLAST_PROOF_PLATES));
    public static final RegistryObject<Block> POTTED_CREEPER_SPORES = HELPER.createBlockNoItem("potted_creeper_spores", () -> new PottedCreeperSporesBlock((Supplier<Item>)SRItems.CREEPER_SPORES, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_)));
    public static final RegistryObject<Block> SPORE_BOMB = HELPER.createBlock("spore_bomb", () -> new SporeBombBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50077_)));
    public static final RegistryObject<Block> CREEPER_SPORE_SACK = HELPER.createBlock("creeper_spore_sack", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283778_).m_60978_(0.5f).m_60918_(SoundType.f_56745_)));

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"savage_and_ravage").tab(CreativeModeTabs.f_256788_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50076_}), new Supplier[]{GLOOMY_TILES, RUNED_GLOOMY_TILES, GLOOMY_TILE_STAIRS, GLOOMY_TILE_SLAB, GLOOMY_TILE_WALL, CHISELED_GLOOMY_TILES}).addItems(new Supplier[]{BLAST_PROOF_PLATES, BLAST_PROOF_STAIRS, BLAST_PROOF_SLAB}).tab(CreativeModeTabs.f_256776_).addItemsAfter(SRBlocks.modLoaded((ItemLike)Blocks.f_220861_, "quark"), new Supplier[]{CREEPER_SPORE_SACK}).tab(CreativeModeTabs.f_256797_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41996_}), new Supplier[]{SPORE_BOMB}).tab(CreativeModeTabs.f_257028_).addItemsAfter((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41996_}), new Supplier[]{SPORE_BOMB});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static class SRProperties {
        public static final BlockBehaviour.Properties GLOOMY_TILES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283791_).m_60999_().m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_);
        public static final BlockBehaviour.Properties LIGHTABLE_GLOOMY_TILES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283791_).m_60999_().m_60913_(1.5f, 6.0f).m_60953_(SRProperties.getLightValuePowered(7)).m_60918_(SoundType.f_56742_);
        public static final BlockBehaviour.Properties BLAST_PROOF_PLATES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60999_().m_60913_(3.0f, 1200.0f).m_60918_(SoundType.f_56743_);

        public static ToIntFunction<BlockState> getLightValuePowered(int lightValue) {
            return stateHolder -> (Boolean)stateHolder.m_61143_((Property)BlockStateProperties.f_61448_) != false ? lightValue : 0;
        }
    }
}

