/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.core.other;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.savage_and_ravage.common.entity.decoration.BurningBanner;
import com.teamabnormals.savage_and_ravage.common.entity.item.SporeBomb;
import com.teamabnormals.savage_and_ravage.common.entity.projectile.MischiefArrow;
import com.teamabnormals.savage_and_ravage.common.entity.projectile.SporeCloud;
import com.teamabnormals.savage_and_ravage.common.item.CreeperSporesItem;
import com.teamabnormals.savage_and_ravage.core.other.SREvents;
import com.teamabnormals.savage_and_ravage.core.other.tags.SRBlockTags;
import com.teamabnormals.savage_and_ravage.core.registry.SRBlocks;
import com.teamabnormals.savage_and_ravage.core.registry.SRItems;
import com.teamabnormals.savage_and_ravage.core.registry.SRSounds;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class SRCompat {
    public static void registerCompat() {
        SRCompat.registerFlammables();
        SRCompat.registerDispenserBehaviors();
        SRCompat.registerNoteBlocks();
    }

    private static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)SRBlocks.CREEPER_SPORE_SACK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)SRBlocks.SPORE_BOMB.get()), (int)15, (int)100);
    }

    private static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SRItems.MISCHIEF_ARROW.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level world, Position position, ItemStack stack) {
                return new MischiefArrow(world, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SRItems.CREEPER_SPORES.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level world, Position position, ItemStack stack) {
                SporeCloud cloud = new SporeCloud(world, position.m_7096_(), position.m_7098_(), position.m_7094_());
                cloud.setCloudSize(CreeperSporesItem.getThrownSporeCloudSize(world.m_213780_()));
                return cloud;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SRBlocks.SPORE_BOMB.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                ServerLevel world = source.m_7727_();
                BlockPos blockpos = BlockUtil.offsetPos((BlockSource)source);
                SporeBomb sporeBomb = new SporeBomb((Level)world, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, null);
                world.m_7967_((Entity)sporeBomb);
                world.m_6263_(null, sporeBomb.m_20185_(), sporeBomb.m_20186_(), sporeBomb.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.m_41774_(1);
                return stack;
            }
        });
        ForgeRegistries.ITEMS.getEntries().stream().map(Map.Entry::getValue).filter(i -> i instanceof BannerItem).forEach(i -> DataUtil.registerAlternativeDispenseBehavior((DataUtil.AlternativeDispenseBehavior)new DataUtil.AlternativeDispenseBehavior("savage_and_ravage", i, (source, stack) -> !BlockUtil.getEntitiesAtOffsetPos((BlockSource)source, LivingEntity.class, EntitySelector.f_20408_.and(new EntitySelector.MobCanWearArmorEntitySelector(stack))).isEmpty(), ArmorItem.f_40376_, (id1, id2) -> id2.equals("quark") ? 1 : 0)));
        DataUtil.registerAlternativeDispenseBehavior((DataUtil.AlternativeDispenseBehavior)new DataUtil.AlternativeDispenseBehavior("savage_and_ravage", Items.f_42409_, (source, stack) -> SREvents.isValidBurningBannerPos((Level)source.m_7727_(), BlockUtil.offsetPos((BlockSource)source)), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                ServerLevel world = source.m_7727_();
                world.m_7967_((Entity)new BurningBanner((Level)world, BlockUtil.offsetPos((BlockSource)source), null));
                if (stack.m_220157_(1, world.f_46441_, null)) {
                    stack.m_41764_(0);
                }
                return stack;
            }
        }));
    }

    private static void registerNoteBlocks() {
        DataUtil.registerNoteBlockInstrument((DataUtil.CustomNoteBlockInstrument)new DataUtil.CustomNoteBlockInstrument("savage_and_ravage", source -> source.m_6414_().m_60713_(Blocks.f_50716_), (SoundEvent)SRSounds.BLOCK_NOTE_BLOCK_HIT_MARKER.get()));
        DataUtil.registerNoteBlockInstrument((DataUtil.CustomNoteBlockInstrument)new DataUtil.CustomNoteBlockInstrument("savage_and_ravage", source -> source.m_6414_().m_204336_(SRBlockTags.HARPSICHORD_NOTE_BLOCKS), (SoundEvent)SRSounds.BLOCK_NOTE_BLOCK_HARPSICHORD.get()));
        DataUtil.registerNoteBlockInstrument((DataUtil.CustomNoteBlockInstrument)new DataUtil.CustomNoteBlockInstrument("savage_and_ravage", source -> source.m_6414_().m_204336_(SRBlockTags.ORCHESTRAL_NOTE_BLOCKS), (SoundEvent)SRSounds.BLOCK_NOTE_BLOCK_ORCHESTRAL_HIT.get()));
    }
}

