/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.projectile;

import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class IceChunk
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int HOVER_TIME = 80;
    public static final int HOVER_DISTANCE = 3;
    private UUID casterEntityUUID;
    private int casterEntity;
    private UUID targetEntityUUID;
    private int targetEntity;
    private int hoverTicks;

    public IceChunk(EntityType<IceChunk> entityType, Level world) {
        super(entityType, world);
    }

    public IceChunk(Level world, @Nullable Entity caster, @Nullable Entity target) {
        this((EntityType<IceChunk>)((EntityType)SREntityTypes.ICE_CHUNK.get()), world);
        if (target != null) {
            this.m_19890_(target.m_20185_(), target.m_20227_(1.0) + 3.0, target.m_20189_(), this.m_146908_(), this.m_146909_());
        }
        this.setCaster(caster);
        this.setTarget(target);
    }

    private void onImpact(HitResult result) {
        if (!this.m_9236_().m_5776_()) {
            BlockState state = Blocks.f_50354_.m_49966_();
            SoundType soundtype = state.getSoundType((LevelReader)this.m_9236_(), this.m_20183_(), null);
            this.m_5496_(soundtype.m_56775_(), (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), 256, (double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0, 1.0);
        }
        this.m_146870_();
    }

    private void onImpactEntity(EntityHitResult result) {
        Entity entity = result.m_82443_();
        entity.m_6469_(this.m_269291_().m_269104_((Entity)this, this.getCaster()), 8.0f);
        if (entity instanceof LivingEntity && entity.m_142079_()) {
            entity.m_146917_(600);
        }
    }

    @Nullable
    public Entity getCaster() {
        if (this.casterEntityUUID != null && this.m_9236_() instanceof ServerLevel) {
            return ((ServerLevel)this.m_9236_()).m_8791_(this.casterEntityUUID);
        }
        return this.casterEntity != 0 ? this.m_9236_().m_6815_(this.casterEntity) : null;
    }

    public void setCaster(@Nullable Entity caster) {
        this.casterEntity = caster == null ? 0 : caster.m_19879_();
        this.casterEntityUUID = caster == null ? null : caster.m_20148_();
    }

    @Nullable
    public Entity getTarget() {
        if (this.targetEntityUUID != null && this.m_9236_() instanceof ServerLevel) {
            return ((ServerLevel)this.m_9236_()).m_8791_(this.targetEntityUUID);
        }
        return this.targetEntity != 0 ? this.m_9236_().m_6815_(this.targetEntity) : null;
    }

    public void setTarget(@Nullable Entity target) {
        this.targetEntity = target == null ? 0 : target.m_19879_();
        this.targetEntityUUID = target == null ? null : target.m_20148_();
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.hoverTicks;
        Entity target = this.getTarget();
        if (this.hoverTicks < 80) {
            if (target != null) {
                this.m_6034_(target.m_20185_(), target.m_20227_(1.0) + 3.0, target.m_20189_());
            }
        } else if (this.hoverTicks >= 100) {
            if (target != null) {
                this.m_20256_(Vec3.f_82478_);
            }
            this.setTarget(null);
        }
        if (!this.m_9236_().m_5776_()) {
            HitResult result = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            List intersecting = this.m_9236_().m_6443_(Entity.class, this.m_20191_(), this::canHitEntity);
            if (result.m_6662_() != HitResult.Type.MISS || !intersecting.isEmpty()) {
                intersecting.forEach(e -> this.onImpactEntity(new EntityHitResult(e)));
                if (result.m_6662_() == HitResult.Type.ENTITY && intersecting.isEmpty()) {
                    this.onImpactEntity((EntityHitResult)result);
                }
                this.onImpact(result);
            }
        }
        if (target == null) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
            this.m_6034_(this.m_20185_() + this.m_20184_().m_7096_(), this.m_20186_() + this.m_20184_().m_7098_(), this.m_20189_() + this.m_20184_().m_7094_());
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && !entity.f_19794_) {
            Entity caster = this.getCaster();
            return caster == null || !caster.m_20365_(entity);
        }
        return false;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag nbt) {
        this.casterEntityUUID = nbt.m_128403_("Caster") ? nbt.m_128342_("Caster") : null;
        this.targetEntityUUID = nbt.m_128403_("Target") ? nbt.m_128342_("Target") : null;
        this.hoverTicks = nbt.m_128451_("HoverTicks");
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.casterEntityUUID != null) {
            nbt.m_128362_("Caster", this.casterEntityUUID);
        }
        if (this.targetEntityUUID != null) {
            nbt.m_128362_("Target", this.targetEntityUUID);
        }
        nbt.m_128405_("HoverTicks", this.hoverTicks);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        Entity target = this.getTarget();
        buf.m_130130_(target == null ? 0 : target.m_19879_());
        buf.m_130130_(this.hoverTicks);
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.targetEntity = buf.m_130242_();
        this.hoverTicks = buf.m_130242_();
    }
}

