/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.sanguine_arsenal.entities;

import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import ru.blatfan.sanguine_arsenal.core.init.EntityInit;

public class FlyingScytheEntity
extends ThrowableItemProjectile {
    public static final EntityDataAccessor<ItemStack> SCYTHE = SynchedEntityData.m_135353_(FlyingScytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public ItemStack scythe;
    public UUID ownerUUID;
    public Player owner;
    public Vec3 shooterPos;
    public int slot;
    public float damage;
    public int age;
    public int returnAge = 20;
    public int maxDistant = 20;
    public boolean returning;

    public FlyingScytheEntity(Level level) {
        super((EntityType)EntityInit.FLYING_SCYTHE.get(), level);
        this.f_19794_ = false;
    }

    public Player owner() {
        if (this.owner == null && !this.m_9236_().f_46443_) {
            this.owner = (Player)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
        }
        return this.owner;
    }

    public void setData(float damage, UUID ownerUUID, int slot, ItemStack scythe) {
        this.damage = damage;
        this.ownerUUID = ownerUUID;
        this.slot = slot;
        this.scythe = scythe;
    }

    public void m_37251_(Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.m_14031_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, innacuracy);
        this.shooterPos = shooter.m_20182_();
        Vec3 vec3 = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, 0.0, vec3.f_82481_));
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.returning = true;
    }

    protected void m_5790_(EntityHitResult result) {
        if (result.m_82443_() == null) {
            return;
        }
        ResourceKey damageTypeResourceKey = DamageTypes.f_268566_;
        Holder.Reference holder = result.m_82443_().m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageTypeResourceKey);
        DamageSource damageSource = new DamageSource((Holder)holder);
        Entity entity = result.m_82443_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.age > 100) {
            return;
        }
        if (entity.equals((Object)this.owner)) {
            return;
        }
        boolean success = entity.m_6469_(damageSource, (float)((double)this.damage * (this.shooterPos.m_82554_(this.m_20182_()) / (double)((float)this.maxDistant / 1.5f))));
        if (success) {
            if (entity instanceof LivingEntity) {
                this.scythe.m_41622_(1, (LivingEntity)this.owner(), e -> this.m_142687_(Entity.RemovalReason.DISCARDED));
            }
            this.returning = true;
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11847_, entity.m_5720_(), 1.0f, 0.9f + entity.m_9236_().f_46441_.m_188501_() * 0.2f);
        }
    }

    public void m_8119_() {
        LivingEntity nearestEntity;
        super.m_8119_();
        ++this.age;
        if (this.m_9236_() == null) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        Player playerEntity = this.owner();
        if (playerEntity == null || !playerEntity.m_6084_()) {
            ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.scythe);
            entityitem.m_32010_(40);
            entityitem.m_20256_(entityitem.m_20184_().m_82542_(0.0, 1.0, 0.0));
            this.m_9236_().m_7967_((Entity)entityitem);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.m_146909_() == 0.0f && this.m_146908_() == 0.0f) {
            Vec3 vector3d = this.m_20184_();
            this.m_5618_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (this.shooterPos != null && this.shooterPos.m_82554_(this.m_20182_()) > (double)this.maxDistant) {
            this.returning = true;
        } else if (this.age > this.returnAge) {
            this.returning = true;
        }
        if (this.age < 10) {
            this.f_19794_ = true;
        }
        if (this.age >= 1 && (nearestEntity = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148353_(), (LivingEntity)playerEntity, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82377_(20.0, 5.0, 20.0))) != null && nearestEntity != playerEntity && !(nearestEntity instanceof Animal) && !(nearestEntity instanceof ArmorStand)) {
            Vec3 entityPos = nearestEntity.m_20182_().m_82520_(0.0, 0.5, 0.0);
            Vec3 motion = entityPos.m_82546_(this.m_20182_());
            this.m_20256_(motion.m_82541_().m_82490_(0.75));
        }
        if (this.returning) {
            this.f_19794_ = true;
            Vec3 ownerPos = playerEntity.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 motion = ownerPos.m_82546_(this.m_20182_());
            this.m_20256_(motion.m_82541_().m_82490_(0.75));
        }
        float distance = this.m_20270_((Entity)playerEntity);
        if (this.age > 8 && distance < 3.0f && this.m_6084_()) {
            if (playerEntity.m_150109_().m_36062_() == -1) {
                return;
            }
            ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)this.scythe, (int)this.slot);
            if (!playerEntity.m_150110_().f_35937_) {
                int cooldown = 20;
                playerEntity.m_36335_().m_41524_(this.scythe.m_41720_(), cooldown);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("scythe", (Tag)this.scythe.serializeNBT());
        if (this.ownerUUID != null) {
            compound.m_128362_("ownerUUID", this.ownerUUID);
        }
        compound.m_128405_("slot", this.slot);
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("age", this.age);
        compound.m_128379_("returning", this.returning);
        compound.m_128405_("returnAge", this.returnAge);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("scythe")) {
            this.scythe = ItemStack.m_41712_((CompoundTag)compound.m_128469_("scythe"));
        }
        this.f_19804_.m_135381_(SCYTHE, (Object)this.scythe);
        if (compound.m_128441_("ownerUUID")) {
            this.ownerUUID = compound.m_128342_("ownerUUID");
            this.owner = this.owner();
        }
        this.slot = compound.m_128451_("slot");
        this.damage = compound.m_128457_("damage");
        this.age = compound.m_128451_("age");
        this.returning = compound.m_128471_("returning");
        this.returnAge = compound.m_128451_("returnAge");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCYTHE, (Object)ItemStack.f_41583_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_7881_() {
        if (this.scythe == null) {
            this.scythe = (ItemStack)this.f_19804_.m_135370_(SCYTHE);
        }
        return this.scythe.m_41720_();
    }

    public ItemStack m_7846_() {
        if (this.scythe == null) {
            this.scythe = (ItemStack)this.f_19804_.m_135370_(SCYTHE);
        }
        return this.scythe;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

