/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.sanguine_arsenal;

import java.util.Objects;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.blatfan.sanguine_arsenal.core.SangArsConfig;
import ru.blatfan.sanguine_arsenal.core.Util.Events;
import ru.blatfan.sanguine_arsenal.core.init.BlockInit;
import ru.blatfan.sanguine_arsenal.core.init.EntityInit;
import ru.blatfan.sanguine_arsenal.core.init.ItemInit;
import ru.blatfan.sanguine_arsenal.core.init.ModelInit;
import ru.blatfan.sanguine_arsenal.core.init.ParticleInit;
import ru.blatfan.sanguine_arsenal.core.init.SangArsItemGroup;
import ru.blatfan.sanguine_arsenal.recipes.EidolonCrucible;
import ru.blatfan.sanguine_arsenal.recipes.EidolonWorktable;
import ru.blatfan.sanguine_arsenal.recipes.rituals.EidolonRituals;
import ru.blatfan.sanguine_arsenal.renderers.FlyingScytheRenderer;
import software.bernie.geckolib.GeckoLib;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="sanguine_arsenal")
@Mod.EventBusSubscriber(modid="sanguine_arsenal", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SanguineArsenal {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "sanguine_arsenal";

    public SanguineArsenal() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SangArsConfig.COMMON_CONFIG);
        bus.addListener(this::setup);
        ParticleInit.ServerParticleRegistry.init(bus);
        ItemInit.ITEMS.register(bus);
        BlockInit.BLOCKS.register(bus);
        EntityInit.ENTITIES.register(bus);
        SangArsItemGroup.TABS.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        }
        GeckoLib.initialize();
    }

    @SubscribeEvent
    public static void onRegisterItems(RegisterEvent event) {
        BlockInit.BLOCKS.getEntries().stream().forEach(block -> event.register(ForgeRegistries.Keys.ITEMS, helper -> helper.register(new ResourceLocation(Objects.requireNonNull(block.getId().toString())), (Object)new BlockItem((Block)block.get(), new Item.Properties()))));
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            EidolonCrucible.init();
            EidolonRituals.init();
            EidolonWorktable.init();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityInit.FLYING_SCYTHE.get()), FlyingScytheRenderer::new);
        event.enqueueWork(() -> ModelInit.registerRenderers(event));
    }

    public void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
    }
}

