/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.NetworkHandler;
import it.hurts.octostudios.rarcompat.network.packets.PacketCreateZone;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.HotkeyRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ScarfOfInvisibilityItem
extends WearableRelicItem {
    protected static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"invisible").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"threshold").initialValue(0.07, 0.08).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.03).formatValue(value -> {
            if (value >= 0.1) {
                return MathUtils.round((double)value, (int)1);
            }
            return MathUtils.round((double)value, (int)3);
        }).build()).stat(StatData.builder((String)"radius").initialValue(8.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ScarfOfInvisibilityItem.getBlockPos(stack).equals((Object)Vec3.f_82478_) && !player.m_9236_().f_46443_) {
            if (player.f_19797_ % 5 == 0) {
                ScarfOfInvisibilityItem.saveWorldPos(stack, player.m_20182_());
            }
            double thresholdValue = this.getAbilityValue(stack, "invisible", "threshold");
            if ((double)player.m_6113_() <= thresholdValue) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
                if (player.f_19797_ % 20 == 0) {
                    this.addExperience(stack, 1);
                }
            } else if (!player.m_20142_() && player.m_6047_() && thresholdValue < (double)0.9f) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
                if (player.f_19797_ % 20 == 0) {
                    this.addExperience(stack, 1);
                }
            } else if (player.m_20182_().toString().equals(stack.m_41783_().m_128461_("position")) && thresholdValue < (double)0.9f && !player.m_20142_()) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
            }
        } else {
            ScarfOfInvisibilityItem.updateInvisibilityZone(player.m_9236_(), player, this.getAbilityValue(stack, "invisible", "radius"), stack);
        }
    }

    public void onUnequip(LivingEntity entity, ItemStack stack) {
        super.onUnequip(entity, stack);
        ScarfOfInvisibilityItem.setWorldPos(stack, Vec3.f_82478_);
    }

    public static void updateInvisibilityZone(Level level, Player player, double radius, ItemStack itemStack) {
        if (player == null) {
            return;
        }
        RandomSource random = player.m_217043_();
        if (level.f_46443_) {
            return;
        }
        ScarfOfInvisibilityItem.checkDistance(player, radius);
        ScarfOfInvisibilityItem.createCyl(ParticleUtils.constructSimpleSpark((Color)new Color(random.m_188503_(50), random.m_188503_(50), 50 + random.m_188503_(55)), (float)0.5f, (int)1, (float)1.0f), ScarfOfInvisibilityItem.getBlockPos(itemStack), level, radius, 0.1f);
    }

    public static void saveWorldPos(ItemStack stack, Vec3 pose) {
        String[] parts = pose.toString().replace("(", "").replace(")", "").split(",\\s*");
        double x = Double.parseDouble(parts[0]);
        double y = Double.parseDouble(parts[1]);
        double z = Double.parseDouble(parts[2]);
        NBTUtils.setString((ItemStack)stack, (String)"position", (String)("(" + x + ", " + y + ", " + z + ")"));
    }

    public static void createCyl(ParticleOptions particle, Vec3 center, Level level, double radius, float step) {
        int offset = 16;
        double len = Math.PI * 2 * radius;
        int num = (int)(len / (double)step);
        for (int i = 0; i < num; ++i) {
            int tries;
            double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / (double)step - (double)num) / (double)num / len));
            double extraX = radius * Math.sin(angle) + center.m_7096_();
            double extraZ = radius * Math.cos(angle) + center.m_7094_();
            double extraY = center.m_7098_();
            boolean foundPos = false;
            for (tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(extraX, extraY, extraZ);
                BlockPos pos = new BlockPos(Mth.m_14107_((double)extraX), Mth.m_14107_((double)extraY), Mth.m_14107_((double)extraZ));
                BlockState state = level.m_8055_(pos);
                VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
                if (state.m_60734_() instanceof LiquidBlock) {
                    shape = Shapes.m_83144_();
                }
                if (shape.m_83281_()) {
                    if (!foundPos) {
                        extraY -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.m_83281_()) break;
                AABB aabb = shape.m_83215_();
                if (!aabb.m_82338_(pos).m_82390_(vec)) {
                    if (!(aabb.f_82292_ >= 1.0)) break;
                    extraY += 1.0;
                    continue;
                }
                extraY += (double)step;
            }
            if (tries >= offset * 2) continue;
            ((ServerLevel)level).m_8767_(particle, extraX, extraY + (double)0.1f, extraZ, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void checkDistance(Player playerOwner, double radius) {
        Level level = playerOwner.m_9236_();
        if (level.f_46443_) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)playerOwner, (Item)((Item)ModItems.SCARF_OF_INVISIBILITY.get()));
        int offset = 16;
        if (ScarfOfInvisibilityItem.getBlockPos(stack).m_82554_(playerOwner.m_20182_()) <= radius) {
            return;
        }
        RandomSource random = playerOwner.m_217043_();
        int particleCount = (int)(radius * 75.0);
        for (int i = 0; i < particleCount; ++i) {
            int tries;
            double angle = (double)i * (Math.PI * 2 / (double)particleCount);
            double x = radius * Math.cos(angle) + ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).f_82479_;
            double y = ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).f_82480_;
            double z = radius * Math.sin(angle) + ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).f_82481_;
            boolean foundPos = false;
            for (tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(x, y, z);
                BlockPos pos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
                BlockState state = level.m_8055_(pos);
                VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
                if (state.m_60734_() instanceof LiquidBlock) {
                    shape = Shapes.m_83144_();
                }
                if (shape.m_83281_()) {
                    if (!foundPos) {
                        y -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.m_83281_()) break;
                AABB aabb = shape.m_83215_();
                if (!aabb.m_82338_(pos).m_82390_(vec)) {
                    if (!(aabb.f_82292_ >= 1.0)) break;
                    y += 1.0;
                    continue;
                }
                y += (double)0.1f;
            }
            if (tries >= offset * 2) continue;
            ((ServerLevel)level).m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(random.m_188503_(50), random.m_188503_(50), 50 + random.m_188503_(55)), (float)0.5f, (int)((int)(radius * (40.0 / radius))), (float)0.9f), x, y, z, 2, 0.0, 0.02 + random.m_188500_() * 0.02, 0.0, 0.1);
        }
        ScarfOfInvisibilityItem.setWorldPos(stack, Vec3.f_82478_);
    }

    public static Vec3 getBlockPos(ItemStack stack) {
        double x = NBTUtils.getDouble((ItemStack)stack, (String)"x", (double)0.0);
        double y = NBTUtils.getDouble((ItemStack)stack, (String)"y", (double)0.0);
        double z = NBTUtils.getDouble((ItemStack)stack, (String)"z", (double)0.0);
        return new Vec3(x, y, z);
    }

    public static void setWorldPos(ItemStack stack, Vec3 val) {
        NBTUtils.setDouble((ItemStack)stack, (String)"x", (double)val.f_82479_);
        NBTUtils.setDouble((ItemStack)stack, (String)"y", (double)val.f_82480_);
        NBTUtils.setDouble((ItemStack)stack, (String)"z", (double)val.f_82481_);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onMouseInput(InputEvent.MouseButton.Pre event) {
            LocalPlayer playerClient = Minecraft.m_91087_().f_91074_;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)playerClient, (Item)((Item)ModItems.SCARF_OF_INVISIBILITY.get()));
            Item item = stack.m_41720_();
            if (item instanceof ScarfOfInvisibilityItem) {
                ScarfOfInvisibilityItem relic = (ScarfOfInvisibilityItem)item;
                if (playerClient != null && !HotkeyRegistry.ABILITY_LIST.m_90857_() && event.getButton() != HotkeyRegistry.ABILITY_LIST.getKey().m_84873_() && playerClient.m_21023_((MobEffect)EffectRegistry.VANISHING.get()) && !playerClient.m_242612_() && Minecraft.m_91087_().f_91080_ == null) {
                    NetworkHandler.sendToServer(new PacketCreateZone());
                    Events.createBallParticles((Player)playerClient, stack, relic.getAbilityValue(stack, "invisible", "radius"));
                }
            }
        }

        public static void createBallParticles(Player player, ItemStack stack, double radius) {
            Level level = player.m_9236_();
            RandomSource random = player.m_217043_();
            int i = 0;
            while ((double)i < radius * 50.0) {
                double theta = Math.PI * 2 * random.m_188500_();
                double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
                double velocityX = radius * Math.sin(phi) * Math.cos(theta);
                double velocityY = radius * Math.sin(phi) * Math.sin(theta);
                double velocityZ = radius * Math.cos(phi);
                level.m_7106_(ParticleUtils.constructSimpleSpark((Color)new Color(random.m_188503_(50), random.m_188503_(50), 50 + random.m_188503_(55)), (float)0.5f, (int)((int)(radius * (17.0 / radius))), (float)0.9f), ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).f_82479_, ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).f_82480_ + 1.0, ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).f_82481_, velocityX * 0.055, velocityY * 0.055, velocityZ * 0.055);
                ++i;
            }
        }
    }
}

