/*
 * Decompiled with CFR 0.152.
 */
package net.projectile_damage.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.projectile_damage.api.EntityAttributes_ProjectileDamage;
import net.projectile_damage.api.IProjectileWeapon;
import net.projectile_damage.api.RangedWeaponKind;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
class ServerWorldMixin {
    ServerWorldMixin() {
    }

    @Inject(method={"spawnEntity"}, at={@At(value="HEAD")})
    private void pre_spawnEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        AbstractArrow projectile;
        if (entity instanceof AbstractArrow && (projectile = (AbstractArrow)entity).m_19749_() != null && projectile.m_19749_() instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)projectile.m_19749_();
            InteractionHand usedHand = null;
            ItemStack usedStack = null;
            RangedWeaponKind weaponKind = this.getWeaponKind(owner.m_21205_());
            if (weaponKind != null) {
                usedStack = owner.m_21205_();
                usedHand = InteractionHand.MAIN_HAND;
            } else {
                weaponKind = this.getWeaponKind(owner.m_21206_());
                if (weaponKind != null) {
                    usedStack = owner.m_21206_();
                    usedHand = InteractionHand.OFF_HAND;
                }
            }
            if (usedStack != null) {
                owner.m_21204_().m_22178_(usedStack.m_41638_(usedHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
            }
            double projectileDamage = owner.m_21133_(EntityAttributes_ProjectileDamage.GENERIC_PROJECTILE_DAMAGE);
            if (weaponKind != null && projectileDamage > 0.0) {
                IProjectileWeapon projectileWeapon;
                Double customLaunchVelocity;
                Item item;
                double defaultDamage = weaponKind.damage();
                double defaultVelocity = weaponKind.launchVelocity();
                double velocityMultiplier = 1.0;
                if (usedStack != null && (item = usedStack.m_41720_()) instanceof IProjectileWeapon && (customLaunchVelocity = (projectileWeapon = (IProjectileWeapon)item).getCustomLaunchVelocity()) != null) {
                    velocityMultiplier = defaultVelocity / customLaunchVelocity;
                }
                projectile.m_36781_(projectile.m_36789_() * (projectileDamage / defaultDamage) * velocityMultiplier * weaponKind.adjustingMultiplier());
            }
        }
    }

    @Nullable
    private RangedWeaponKind getWeaponKind(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item == null) {
            return null;
        }
        if (item instanceof IProjectileWeapon) {
            IProjectileWeapon weapon = (IProjectileWeapon)item;
            return weapon.getRangeWeaponKind();
        }
        return null;
    }
}

