/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.playerrevive.PlayerReviveConfig;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.client.ReviveEventClient;
import team.creative.playerrevive.packet.GiveUpPacket;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.packet.ReviveUpdatePacket;
import team.creative.playerrevive.server.PlayerReviveServer;
import team.creative.playerrevive.server.ReviveEventServer;

@Mod(value="playerrevive")
public class PlayerRevive {
    public static final Logger LOGGER = LogManager.getLogger((String)"playerrevive");
    public static final String MODID = "playerrevive";
    public static PlayerReviveConfig CONFIG;
    public static final CreativeNetwork NETWORK;
    public static final ResourceLocation BLEEDING_NAME;
    public static final ResourceKey<DamageType> BLED_TO_DEATH;
    public static final SoundEvent DEATH_SOUND;
    public static final SoundEvent REVIVED_SOUND;
    public static final Capability<IBleeding> BLEEDING;

    public void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, x -> {
            x.register(new ResourceLocation(MODID, "death"), (Object)DEATH_SOUND);
            x.register(new ResourceLocation(MODID, "revived"), (Object)REVIVED_SOUND);
        });
    }

    public PlayerRevive() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::register);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCaps);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void client(FMLClientSetupEvent event) {
        CreativeCoreClient.registerClientConfig((String)MODID);
        MinecraftForge.EVENT_BUS.register((Object)new ReviveEventClient());
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ReviveUpdatePacket.class, ReviveUpdatePacket::new);
        NETWORK.registerType(HelperPacket.class, HelperPacket::new);
        NETWORK.registerType(GiveUpPacket.class, GiveUpPacket::new);
        CONFIG = new PlayerReviveConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)new ReviveEventServer());
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IBleeding.class);
    }

    private void serverStarting(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"revive").requires(x -> x.m_6761_(2))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(x -> {
            Collection players = EntityArgument.m_91477_((CommandContext)x, (String)"players");
            for (ServerPlayer player : players) {
                if (!PlayerReviveServer.getBleeding((Player)player).isBleeding()) continue;
                PlayerReviveServer.revive((Player)player);
            }
            return 0;
        })));
    }

    static {
        NETWORK = new CreativeNetwork(1, LOGGER, new ResourceLocation(MODID, "main"));
        BLEEDING_NAME = new ResourceLocation(MODID, "bleeding");
        BLED_TO_DEATH = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(MODID, "bled_to_death"));
        DEATH_SOUND = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, "death"));
        REVIVED_SOUND = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, "revived"));
        BLEEDING = CapabilityManager.get((CapabilityToken)new CapabilityToken<IBleeding>(){});
    }
}

