/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.command.McCommand;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceReconnectCommand
implements McCommand {
    private final BaseVoiceServer voiceServer;

    @Override
    public void execute(@NotNull McCommandSource source2, @NotNull String[] arguments) {
        if (!(source2 instanceof McServerPlayer)) {
            source2.sendMessage(McTextComponent.translatable("pv.error.player_only_command", new Object[0]));
            return;
        }
        McServerPlayer player = (McServerPlayer)source2;
        VoiceServerPlayer voicePlayer = (VoiceServerPlayer)this.voiceServer.getPlayerManager().getPlayerById(player.getUuid()).orElseThrow(() -> new IllegalStateException("how?"));
        source2.sendMessage(McTextComponent.translatable("pv.command.reconnect.message", new Object[0]));
        this.voiceServer.getUdpConnectionManager().removeConnection(voicePlayer);
        this.voiceServer.getTcpPacketManager().requestPlayerInfo(voicePlayer);
    }

    @Override
    public boolean hasPermission(@NotNull McCommandSource source2, @Nullable String[] arguments) {
        return source2.hasPermission("pv.reconnect");
    }

    public VoiceReconnectCommand(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

