/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.ProximityServerActivationHelper;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.event.player.PlayerActivationDistanceUpdateEvent;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.server.config.VoiceServerConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lsu/plo/voice/server/audio/capture/ProximityServerActivation;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;)V", "proximityHelper", "Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper;", "onActivationDistanceChange", "", "event", "Lsu/plo/voice/api/server/event/player/PlayerActivationDistanceUpdateEvent;", "register", "config", "Lsu/plo/voice/server/config/VoiceServerConfig;", "common"})
public final class ProximityServerActivation {
    @NotNull
    private final PlasmoVoiceServer voiceServer;
    @Nullable
    private ProximityServerActivationHelper proximityHelper;

    public ProximityServerActivation(@NotNull PlasmoVoiceServer voiceServer) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        this.voiceServer = voiceServer;
    }

    public final void register(@NotNull VoiceServerConfig config) {
        block1: {
            Intrinsics.checkNotNullParameter(config, "config");
            ProximityServerActivationHelper proximityServerActivationHelper = this.proximityHelper;
            if (proximityServerActivationHelper != null) {
                ProximityServerActivationHelper it = proximityServerActivationHelper;
                boolean bl = false;
                it.unregisterListeners(this.voiceServer);
                this.voiceServer.getActivationManager().unregister((Activation)it.getActivation());
                this.voiceServer.getSourceLineManager().unregister((SourceLine)it.getSourceLine());
            }
            ServerActivation.Builder builder = this.voiceServer.getActivationManager().createBuilder((Object)this.voiceServer, "proximity", "pv.activation.proximity", "plasmovoice:textures/icons/microphone.png", "pv.activation.proximity", 1);
            ServerActivation serverActivation = builder.setDistances((List<Integer>)config.voice().proximity().distances()).setDefaultDistance(config.voice().proximity().defaultDistance()).setProximity(true).setTransitive(true).setStereoSupported(false).setPermissionDefault(PermissionDefault.TRUE).build();
            Intrinsics.checkNotNullExpressionValue(serverActivation, "build(...)");
            ServerActivation activation = serverActivation;
            ServerSourceLine sourceLine = (ServerSourceLine)this.voiceServer.getSourceLineManager().createBuilder((Object)this.voiceServer, "proximity", "pv.activation.proximity", "plasmovoice:textures/icons/speaker.png", 1).build();
            ProximityServerActivationHelper proximityServerActivationHelper2 = this.proximityHelper = new ProximityServerActivationHelper(this.voiceServer, activation, sourceLine, null, 8, null);
            if (proximityServerActivationHelper2 == null) break block1;
            proximityServerActivationHelper2.registerListeners(this.voiceServer);
        }
    }

    @EventSubscribe
    public final void onActivationDistanceChange(@NotNull PlayerActivationDistanceUpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Intrinsics.areEqual(event.getActivation().getId(), VoiceActivation.PROXIMITY_ID)) {
            return;
        }
        if (event.getOldDistance() == -1) {
            return;
        }
        event.getPlayer().visualizeDistance(event.getDistance());
    }
}

