/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp.bothbound;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Arrays;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.PacketUtil;

public abstract class BaseAudioPacket<T extends PacketHandler>
implements Packet<T> {
    protected long sequenceNumber;
    protected byte[] data;

    public BaseAudioPacket(long sequenceNumber, byte[] data) {
        this.sequenceNumber = sequenceNumber;
        this.data = data;
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.sequenceNumber = in.readLong();
        int length = PacketUtil.readSafeInt(in, 1, 2048);
        byte[] data = new byte[length];
        in.readFully(data);
        this.data = data;
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeLong(this.sequenceNumber);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public BaseAudioPacket() {
    }

    public String toString() {
        return "BaseAudioPacket(sequenceNumber=" + this.getSequenceNumber() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getData() {
        return this.data;
    }
}

