/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\tR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsu/plo/voice/client/audio/source/JitterBuffer;", "", "packetDelay", "", "(I)V", "endPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "queue", "Ljava/util/Queue;", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "offer", "", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "poll", "PacketWithSequenceNumber", "SourceAudioEndPacketWrapper", "SourceAudioPacketWrapper", "plasmovoice-forge-1.20.1"})
public final class JitterBuffer {
    private final int packetDelay;
    @NotNull
    private final Queue<PacketWithSequenceNumber> queue;
    @Nullable
    private SourceAudioEndPacket endPacket;

    public JitterBuffer(int packetDelay) {
        this.packetDelay = packetDelay;
        this.queue = this.packetDelay <= 1 ? (Queue)new LinkedBlockingQueue() : (Queue)new PriorityBlockingQueue(this.packetDelay * 2, new Comparator(){

            public final int compare(T a, T b) {
                PacketWithSequenceNumber it = (PacketWithSequenceNumber)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSequenceNumber());
                it = (PacketWithSequenceNumber)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getSequenceNumber());
            }
        });
    }

    public final void offer(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (this.endPacket != null) {
            long l = packet.getSequenceNumber();
            SourceAudioEndPacket sourceAudioEndPacket = this.endPacket;
            Intrinsics.checkNotNull(sourceAudioEndPacket);
            if (l > sourceAudioEndPacket.getSequenceNumber()) {
                this.endPacket = null;
            }
        }
        this.queue.offer(new SourceAudioPacketWrapper(packet));
    }

    public final void offer(@NotNull SourceAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.endPacket = packet;
        this.queue.offer(new SourceAudioEndPacketWrapper(packet));
    }

    @Nullable
    public final PacketWithSequenceNumber poll() {
        if (this.endPacket != null || this.queue.size() >= this.packetDelay) {
            return this.queue.poll();
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "", "sequenceNumber", "", "getSequenceNumber", "()J", "Lsu/plo/voice/client/audio/source/JitterBuffer$SourceAudioEndPacketWrapper;", "Lsu/plo/voice/client/audio/source/JitterBuffer$SourceAudioPacketWrapper;", "plasmovoice-forge-1.20.1"})
    public static interface PacketWithSequenceNumber {
        public long getSequenceNumber();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lsu/plo/voice/client/audio/source/JitterBuffer$SourceAudioEndPacketWrapper;", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "packet", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "(Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;)V", "getPacket", "()Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "sequenceNumber", "", "getSequenceNumber", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "plasmovoice-forge-1.20.1"})
    public static final class SourceAudioEndPacketWrapper
    implements PacketWithSequenceNumber {
        @NotNull
        private final SourceAudioEndPacket packet;

        public SourceAudioEndPacketWrapper(@NotNull SourceAudioEndPacket packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this.packet = packet;
        }

        @NotNull
        public final SourceAudioEndPacket getPacket() {
            return this.packet;
        }

        @Override
        public long getSequenceNumber() {
            return this.packet.getSequenceNumber();
        }

        @NotNull
        public final SourceAudioEndPacket component1() {
            return this.packet;
        }

        @NotNull
        public final SourceAudioEndPacketWrapper copy(@NotNull SourceAudioEndPacket packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            return new SourceAudioEndPacketWrapper(packet);
        }

        public static /* synthetic */ SourceAudioEndPacketWrapper copy$default(SourceAudioEndPacketWrapper sourceAudioEndPacketWrapper, SourceAudioEndPacket sourceAudioEndPacket, int n, Object object) {
            if ((n & 1) != 0) {
                sourceAudioEndPacket = sourceAudioEndPacketWrapper.packet;
            }
            return sourceAudioEndPacketWrapper.copy(sourceAudioEndPacket);
        }

        @NotNull
        public String toString() {
            return "SourceAudioEndPacketWrapper(packet=" + this.packet + ")";
        }

        public int hashCode() {
            return this.packet.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceAudioEndPacketWrapper)) {
                return false;
            }
            SourceAudioEndPacketWrapper sourceAudioEndPacketWrapper = (SourceAudioEndPacketWrapper)other;
            return Intrinsics.areEqual(this.packet, sourceAudioEndPacketWrapper.packet);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lsu/plo/voice/client/audio/source/JitterBuffer$SourceAudioPacketWrapper;", "Lsu/plo/voice/client/audio/source/JitterBuffer$PacketWithSequenceNumber;", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "(Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;)V", "getPacket", "()Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "sequenceNumber", "", "getSequenceNumber", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "plasmovoice-forge-1.20.1"})
    public static final class SourceAudioPacketWrapper
    implements PacketWithSequenceNumber {
        @NotNull
        private final SourceAudioPacket packet;

        public SourceAudioPacketWrapper(@NotNull SourceAudioPacket packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this.packet = packet;
        }

        @NotNull
        public final SourceAudioPacket getPacket() {
            return this.packet;
        }

        @Override
        public long getSequenceNumber() {
            return this.packet.getSequenceNumber();
        }

        @NotNull
        public final SourceAudioPacket component1() {
            return this.packet;
        }

        @NotNull
        public final SourceAudioPacketWrapper copy(@NotNull SourceAudioPacket packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            return new SourceAudioPacketWrapper(packet);
        }

        public static /* synthetic */ SourceAudioPacketWrapper copy$default(SourceAudioPacketWrapper sourceAudioPacketWrapper, SourceAudioPacket sourceAudioPacket, int n, Object object) {
            if ((n & 1) != 0) {
                sourceAudioPacket = sourceAudioPacketWrapper.packet;
            }
            return sourceAudioPacketWrapper.copy(sourceAudioPacket);
        }

        @NotNull
        public String toString() {
            return "SourceAudioPacketWrapper(packet=" + this.packet + ")";
        }

        public int hashCode() {
            return this.packet.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceAudioPacketWrapper)) {
                return false;
            }
            SourceAudioPacketWrapper sourceAudioPacketWrapper = (SourceAudioPacketWrapper)other;
            return Intrinsics.areEqual(this.packet, sourceAudioPacketWrapper.packet);
        }
    }
}

