/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSink;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import su.plo.lib.mod.client.chat.ClientTextConverter;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.VertexFormatMode;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.extension.TextKt;
import su.plo.voice.universal.TextBuilder;

public final class RenderUtil {
    private static final Font.DisplayMode TEXT_LAYER_TYPE = Font.DisplayMode.NORMAL;
    private static final ClientTextConverter TEXT_CONVERTER = new ClientTextConverter();
    private static final Map<VertexFormat, Supplier<ShaderInstance>> DEFAULT_SHADERS = new IdentityHashMap<VertexFormat, Supplier<ShaderInstance>>();

    public static void enableScissor(int x, int y, int width, int height) {
        double scaleFactor = Minecraft.m_91087_().m_91268_().m_85449_();
        double scaledX = (double)x * scaleFactor;
        double scaledY = (double)y * scaleFactor;
        double scaledWidth = (double)width * scaleFactor;
        double scaledHeight = (double)height * scaleFactor;
        RenderSystem.enableScissor((int)((int)scaledX), (int)((int)scaledY), (int)Math.max(0, (int)scaledWidth), (int)Math.max(0, (int)scaledHeight));
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    @NotNull
    public static BufferBuilder beginBufferWithDefaultShader(@NotNull VertexFormatMode mode, @NotNull VertexFormat format) {
        Supplier<ShaderInstance> shader = DEFAULT_SHADERS.get(format);
        if (shader == null) {
            throw new IllegalArgumentException("No default shader for " + format + ". Bind your own and use beginBufferWithActiveShader instead.");
        }
        RenderSystem.setShader(shader);
        return RenderUtil.beginBufferWithActiveShader(mode, format);
    }

    @NotNull
    public static BufferBuilder beginBufferWithActiveShader(@NotNull VertexFormatMode mode, @NotNull VertexFormat format) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(mode.toMc(), format);
        return buffer;
    }

    public static void drawBuffer(@NotNull BufferBuilder buffer) {
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void bindTexture(int index, @NotNull ResourceLocation location) {
        RenderSystem.setShaderTexture((int)index, (ResourceLocation)location);
    }

    public static void configureTextureUnit(int index, Runnable block) {
        int prevActiveTexture = RenderUtil.getActiveTexture();
        RenderUtil.setActiveTexture(33984 + index);
        block.run();
        RenderUtil.setActiveTexture(prevActiveTexture);
    }

    public static int getActiveTexture() {
        return GL11.glGetInteger((int)34016);
    }

    public static void setActiveTexture(int glId) {
        GlStateManager._activeTexture((int)glId);
    }

    public static int getOrLoadTextureId(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        AbstractTexture texture = textureManager.m_118506_(resourceLocation);
        if (texture == null) {
            texture = new SimpleTexture(resourceLocation);
            textureManager.m_118495_(resourceLocation, texture);
        }
        return texture.m_117963_();
    }

    public static void fill(PoseStack stack, int x0, int y0, int x1, int y1, int color) {
        int n;
        if (x0 < x1) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y0 < y1) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float o = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderUtil.defaultBlendFunc();
        BufferBuilder buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.QUADS, DefaultVertexFormat.f_85815_);
        VertexBuilder.create(buffer).position(stack, x0, y1, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, 0.0f).color(g, h, o, f).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, 0.0f).color(g, h, o, f).end();
        RenderUtil.drawBuffer(buffer);
        RenderSystem.disableBlend();
    }

    public static void fillGradient(PoseStack stack, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z) {
        int f = colorStart >> 24 & 0xFF;
        int g = colorStart >> 16 & 0xFF;
        int h = colorStart >> 8 & 0xFF;
        int i = colorStart & 0xFF;
        int j = colorEnd >> 24 & 0xFF;
        int k = colorEnd >> 16 & 0xFF;
        int l = colorEnd >> 8 & 0xFF;
        int m = colorEnd & 0xFF;
        RenderUtil.fillGradient(stack, startX, startY, endX, endY, g, h, i, f, k, l, m, j, z);
    }

    public static void fillGradient(PoseStack stack, int startX, int startY, int endX, int endY, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha, int z) {
        BufferBuilder buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtil.fillGradient(stack, buffer, startX, startY, endX, endY, z, startRed, startBlue, startGreen, startAlpha, endRed, endBlue, endGreen, endAlpha);
        RenderUtil.drawBuffer(buffer);
    }

    private static void fillGradient(PoseStack stack, BufferBuilder buffer, int startX, int startY, int endX, int endY, int z, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha) {
        VertexBuilder.create(buffer).position(stack, endX, startY, z).color(startRed, startGreen, startBlue, startAlpha).end();
        VertexBuilder.create(buffer).position(stack, startX, startY, z).color(startRed, startGreen, startBlue, startAlpha).end();
        VertexBuilder.create(buffer).position(stack, startX, endY, z).color(endRed, endGreen, endBlue, endAlpha).end();
        VertexBuilder.create(buffer).position(stack, endX, endY, z).color(endRed, endGreen, endBlue, endAlpha).end();
    }

    public static void blitSprite(@NotNull PoseStack stack, @NotNull GuiWidgetTexture sprite, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, u + sprite.getU(), v + sprite.getV(), width, height, sprite.getTextureWidth(), sprite.getTextureHeight());
    }

    public static void blit(PoseStack stack, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, 0, (float)u, (float)v, width, height, 256, 256);
    }

    public static void blit(PoseStack stack, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    public static void blit(PoseStack stack, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(PoseStack stack, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blit(PoseStack stack, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    public static void blit(PoseStack stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        BufferBuilder buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.QUADS, DefaultVertexFormat.f_85817_);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).end();
        RenderUtil.drawBuffer(buffer);
    }

    public static void blitWithActiveShader(PoseStack stack, VertexFormat format, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        BufferBuilder buffer = RenderUtil.beginBufferWithActiveShader(VertexFormatMode.QUADS, format);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).color(red, green, blue, alpha).end();
        RenderUtil.drawBuffer(buffer);
    }

    public static void blitColor(PoseStack stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        BufferBuilder buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.QUADS, DefaultVertexFormat.f_85819_);
        VertexBuilder.create(buffer).position(stack, x0, y1, z).uv(u0, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y1, z).uv(u1, v1).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x1, y0, z).uv(u1, v0).color(red, green, blue, alpha).end();
        VertexBuilder.create(buffer).position(stack, x0, y0, z).uv(u0, v0).color(red, green, blue, alpha).end();
        RenderUtil.drawBuffer(buffer);
    }

    public static void drawStringInBatch(PoseStack stack, String text, int x, int y, int color, boolean shadow) {
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft.m_91087_().f_91062_.m_271703_(text, (float)x, (float)y, color, shadow, stack.m_85850_().m_252922_(), (MultiBufferSource)irendertypebuffer$impl, TEXT_LAYER_TYPE, 0, 0xF000F0);
        irendertypebuffer$impl.m_109911_();
    }

    public static int drawCenteredString(PoseStack stack, String string, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        int centeredX = x - RenderUtil.getStringWidth(string) / 2;
        RenderUtil.drawStringInBatch(stack, string, centeredX, y, color, true);
        return RenderUtil.getStringX(string, centeredX, true);
    }

    public static int drawCenteredString(PoseStack stack, McTextComponent text, int x, int y, int color) {
        return RenderUtil.drawCenteredString(stack, RenderUtil.getFormattedString(text), x, y, color);
    }

    public static void drawCenteredOrderedString(PoseStack stack, McTextComponent text, int width, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        String orderedText = RenderUtil.getOrderedString(text, width);
        RenderUtil.drawStringInBatch(stack, orderedText, x - RenderUtil.getStringWidth(orderedText) / 2, y, color, true);
    }

    public static void drawOrderedString(PoseStack stack, McTextComponent text, int width, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        RenderUtil.drawStringInBatch(stack, RenderUtil.getOrderedString(text, width), x, y, color, true);
    }

    public static int drawString(PoseStack stack, String string, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        RenderUtil.drawStringInBatch(stack, string, x, y, color, false);
        return RenderUtil.getStringX(string, x, false);
    }

    public static int drawString(PoseStack stack, McTextComponent text, int x, int y, int color) {
        return RenderUtil.drawString(stack, text, x, y, color, true);
    }

    public static int drawString(PoseStack stack, McTextComponent text, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String formattedText = RenderUtil.getFormattedString(text);
        RenderUtil.drawStringInBatch(stack, formattedText, x, y, color, dropShadow);
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringLight(PoseStack stack, McTextComponent text, int x, int y, int color, int light, boolean seeThrough, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        String formattedText = RenderUtil.getFormattedString(text);
        Font.DisplayMode displayMode = seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Minecraft.m_91087_().f_91062_.m_271703_(formattedText, (float)x, (float)y, color, dropShadow, stack.m_85850_().m_252922_(), (MultiBufferSource)irendertypebuffer$impl, displayMode, 0, light);
        irendertypebuffer$impl.m_109911_();
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringMultiLine(PoseStack stack, McTextComponent text, int x, int y, int color, int width) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = RenderUtil.getFontHeight();
        for (String orderedText : lines) {
            RenderUtil.drawStringInBatch(stack, orderedText, x, y - lineHeight - 1, color, true);
            y += lineHeight;
        }
        return lines.size();
    }

    public static int drawStringMultiLineCentered(PoseStack stack, McTextComponent text, int width, int y, int yGap, int color) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = RenderUtil.getFontHeight();
        for (String orderedText : lines) {
            RenderUtil.drawStringInBatch(stack, orderedText, width / 2 - RenderUtil.getStringWidth(orderedText) / 2, y + lineHeight, color, true);
            y += lineHeight + yGap;
        }
        return lines.size();
    }

    public static int getStringX(String string, int x, boolean dropShadow) {
        return x + RenderUtil.getStringWidth(string) + (dropShadow ? 1 : 0);
    }

    public static int adjustColor(int color) {
        return (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
    }

    public static String stringToWidth(String string, int width, boolean tail) {
        List<String> lines = TextKt.splitStringToWidthTruncated(string, width, 1, false, true, "...");
        return lines.get(tail ? lines.size() - 1 : 0);
    }

    public static String stringToWidth(String string, int width) {
        return RenderUtil.stringToWidth(string, width, false);
    }

    public static int getTextWidth(McTextComponent text) {
        return RenderUtil.getStringWidth(RenderUtil.getFormattedString(text));
    }

    public static String getOrderedString(McTextComponent text, int width) {
        return TextKt.getTruncatedString(RenderUtil.getFormattedString(text), width, "...");
    }

    public static String getFormattedString(McTextComponent text) {
        Component component = RenderUtil.getTextConverter().convert(text);
        TextBuilder textBuilder = new TextBuilder(true);
        component.m_7532_().m_13731_((FormattedCharSink)textBuilder);
        return textBuilder.getString();
    }

    public static void enableColorLogic() {
        RenderSystem.enableColorLogicOp();
    }

    public static void disableColorLogic() {
        RenderSystem.disableColorLogicOp();
    }

    public static void logicOp(String opcode) {
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.valueOf((String)opcode));
    }

    public static void enableCull() {
        RenderSystem.enableCull();
    }

    public static void disableCull() {
        RenderSystem.disableCull();
    }

    public static void enablePolygonOffset() {
        RenderSystem.enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.disablePolygonOffset();
    }

    public static void polygonOffset(float factor, float units) {
        RenderSystem.polygonOffset((float)factor, (float)units);
    }

    public static void lineWidth(float width) {
        RenderSystem.lineWidth((float)width);
    }

    public static int getStringWidth(String string) {
        return Minecraft.m_91087_().f_91062_.m_92895_(string);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    public static ClientTextConverter getTextConverter() {
        return TEXT_CONVERTER;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
    }

    private RenderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85813_, GameRenderer::m_172829_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85814_, GameRenderer::m_172808_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85816_, GameRenderer::m_172832_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85817_, GameRenderer::m_172817_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85819_, GameRenderer::m_172820_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85820_, GameRenderer::m_172835_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85818_, GameRenderer::m_172814_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85821_, GameRenderer::m_172637_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85822_, GameRenderer::m_172838_);
    }
}

