/*
 * Decompiled with CFR 0.152.
 */
package com.chailotl.particular;

import com.chailotl.particular.ParticularConfig;
import com.chailotl.particular.mixin.AccessorBiome;
import com.chailotl.particular.particles.AcaciaLeafParticle;
import com.chailotl.particular.particles.BirchLeafParticle;
import com.chailotl.particular.particles.CascadeParticle;
import com.chailotl.particular.particles.CaveDustParticle;
import com.chailotl.particular.particles.EnderBubbleParticle;
import com.chailotl.particular.particles.EnderBubblePopParticle;
import com.chailotl.particular.particles.FireflyParticle;
import com.chailotl.particular.particles.JungleLeafParticle;
import com.chailotl.particular.particles.LeafParticle;
import com.chailotl.particular.particles.MangroveLeafParticle;
import com.chailotl.particular.particles.SpruceLeafParticle;
import com.chailotl.particular.particles.WaterRippleParticle;
import com.chailotl.particular.particles.WaterSplashEmitterParticle;
import com.chailotl.particular.particles.WaterSplashFoamParticle;
import com.chailotl.particular.particles.WaterSplashParticle;
import com.chailotl.particular.particles.WaterSplashRingParticle;
import com.chailotl.particular.particles.WaterfallSprayParticle;
import io.wispforest.owo.config.Option;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_703;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements ClientModInitializer {
    public static final String MOD_ID = "particular";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"particular");
    public static final ParticularConfig CONFIG = ParticularConfig.createAndLoad();
    public static List<class_2960> EXCLUDE_CAVE_DUST = new LinkedList<class_2960>();
    public static final class_2400 OAK_LEAF = FabricParticleTypes.simple();
    public static final class_2400 BIRCH_LEAF = FabricParticleTypes.simple();
    public static final class_2400 SPRUCE_LEAF = FabricParticleTypes.simple();
    public static final class_2400 JUNGLE_LEAF = FabricParticleTypes.simple();
    public static final class_2400 ACACIA_LEAF = FabricParticleTypes.simple();
    public static final class_2400 DARK_OAK_LEAF = FabricParticleTypes.simple();
    public static final class_2400 AZALEA_LEAF = FabricParticleTypes.simple();
    public static final class_2400 MANGROVE_LEAF = FabricParticleTypes.simple();
    public static final class_2400 WATER_RIPPLE = FabricParticleTypes.simple();
    public static final class_2400 ENDER_BUBBLE = FabricParticleTypes.simple();
    public static final class_2400 ENDER_BUBBLE_POP = FabricParticleTypes.simple();
    public static final class_2400 CAVE_DUST = FabricParticleTypes.simple();
    public static final class_2400 FIREFLY = FabricParticleTypes.simple();
    public static final class_2400 WATERFALL_SPRAY = FabricParticleTypes.simple();
    public static final class_2400 CASCADE = FabricParticleTypes.simple((boolean)true);
    public static final class_2400 WATER_SPLASH_EMITTER = FabricParticleTypes.simple((boolean)true);
    public static final class_2400 WATER_SPLASH = FabricParticleTypes.simple((boolean)true);
    public static final class_2400 WATER_SPLASH_FOAM = FabricParticleTypes.simple((boolean)true);
    public static final class_2400 WATER_SPLASH_RING = FabricParticleTypes.simple((boolean)true);
    public static class_2960 currentDimension;
    public static Hashtable<class_2338, Integer> cascades;
    private static float fireflyFrequency;

    public void onInitializeClient() {
        LOGGER.info("I am quite particular about the effects I choose to add :3");
        this.updateCaveDust(0);
        CONFIG.optionForKey(new Option.Key("excludeCaveDust")).observe(this::updateCaveDust);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "oak_leaf"), (Object)OAK_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "birch_leaf"), (Object)BIRCH_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "spruce_leaf"), (Object)SPRUCE_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "jungle_leaf"), (Object)JUNGLE_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "acacia_leaf"), (Object)ACACIA_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "dark_oak_leaf"), (Object)DARK_OAK_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "azalea_leaf"), (Object)AZALEA_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "mangrove_leaf"), (Object)MANGROVE_LEAF);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "water_ripple"), (Object)WATER_RIPPLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "ender_bubble"), (Object)ENDER_BUBBLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "ender_bubble_pop"), (Object)ENDER_BUBBLE_POP);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "cave_dust"), (Object)CAVE_DUST);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "firefly"), (Object)FIREFLY);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "waterfall_spray"), (Object)WATERFALL_SPRAY);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "cascade"), (Object)CASCADE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "water_splash_emitter"), (Object)WATER_SPLASH_EMITTER);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "water_splash"), (Object)WATER_SPLASH);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "water_splash_foam"), (Object)WATER_SPLASH_FOAM);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960(MOD_ID, "water_splash_ring"), (Object)WATER_SPLASH_RING);
        ParticleFactoryRegistry.getInstance().register((class_2396)OAK_LEAF, LeafParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)BIRCH_LEAF, BirchLeafParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)SPRUCE_LEAF, SpruceLeafParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)JUNGLE_LEAF, JungleLeafParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ACACIA_LEAF, AcaciaLeafParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)DARK_OAK_LEAF, LeafParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)AZALEA_LEAF, LeafParticle.DefaultFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)MANGROVE_LEAF, MangroveLeafParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)WATER_RIPPLE, WaterRippleParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ENDER_BUBBLE, EnderBubbleParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ENDER_BUBBLE_POP, EnderBubblePopParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)CAVE_DUST, CaveDustParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)FIREFLY, FireflyParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)WATERFALL_SPRAY, WaterfallSprayParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)CASCADE, CascadeParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)WATER_SPLASH_EMITTER, WaterSplashEmitterParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)WATER_SPLASH, WaterSplashParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)WATER_SPLASH_FOAM, WaterSplashFoamParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)WATER_SPLASH_RING, WaterSplashRingParticle.Factory::new);
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (!CONFIG.cascades()) {
                return;
            }
            class_2960 newDimension = world.method_8597().comp_655();
            if (newDimension != currentDimension) {
                currentDimension = newDimension;
                cascades.clear();
            }
            chunk.method_51525(state -> state.method_26227().method_39360((class_3611)class_3612.field_15910), (pos, state) -> Main.updateCascade((class_1937)world, pos, state.method_26227()));
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (!CONFIG.cascades()) {
                return;
            }
            cascades.forEach((pos, strength) -> {
                if (!world.method_22340(pos)) {
                    cascades.remove(pos);
                }
            });
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> cascades.clear());
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            class_5819 random = world.field_9229;
            if (world.method_8532() == 12000L) {
                switch (random.method_39332(0, 5)) {
                    default: {
                        float f = 0.0f;
                        break;
                    }
                    case 3: {
                        float f = 0.33f;
                        break;
                    }
                    case 4: {
                        float f = 0.66f;
                        break;
                    }
                    case 5: {
                        float f = fireflyFrequency = 1.0f;
                    }
                }
            }
            if (!CONFIG.cascades()) {
                return;
            }
            cascades.forEach((pos, strength) -> {
                float height = world.method_8316(pos.method_10084()).method_20785();
                double x = pos.method_10263();
                double y = (double)pos.method_10264() + random.method_43058() * (double)height + 1.0;
                double z = pos.method_10260();
                if (random.method_43056()) {
                    x += random.method_43058();
                    z += (double)random.method_39332(0, 1);
                } else {
                    x += (double)random.method_39332(0, 1);
                    z += random.method_43058();
                }
                class_703 cascade = class_310.method_1551().field_1713.method_3056((class_2394)CASCADE, x, y, z, 0.0, 0.0, 0.0);
                if (cascade != null) {
                    float size = (float)strength.intValue() / 4.0f * height;
                    cascade.method_3087(1.0f - (1.0f - size) / 2.0f);
                }
            });
        });
    }

    public void updateCaveDust(Object o) {
        EXCLUDE_CAVE_DUST = CONFIG.excludeCaveDust().stream().map(class_2960::new).collect(Collectors.toList());
    }

    public static void updateCascade(class_1937 world, class_2338 pos, class_3610 state) {
        if (state.method_39360((class_3611)class_3612.field_15910) && world.method_8316(pos.method_10084()).method_39360((class_3611)class_3612.field_15909) && world.method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910)) {
            int strength = 0;
            if (world.method_8316(pos.method_10095()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10078()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10072()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (world.method_8316(pos.method_10067()).method_39360((class_3611)class_3612.field_15910)) {
                ++strength;
            }
            if (strength > 0) {
                if (!(world.method_8320(pos.method_10084().method_10095()).method_26215() || world.method_8320(pos.method_10084().method_10078()).method_26215() || world.method_8320(pos.method_10084().method_10072()).method_26215() || world.method_8320(pos.method_10084().method_10067()).method_26215())) {
                    return;
                }
                if (cascades.contains(pos = new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()))) {
                    cascades.replace(pos, strength);
                } else {
                    cascades.put(pos, strength);
                }
            } else {
                cascades.remove(pos);
            }
        } else {
            cascades.remove(pos);
        }
    }

    public static void spawnBubble(class_2394 particle, class_1937 world, class_2338 pos) {
        double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * 0.5;
        double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
        double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * 0.5;
        world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnFirefly(class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43058() > (double)fireflyFrequency) {
            return;
        }
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        float downfall = ((AccessorBiome)biome).getWeather().comp_846();
        if (!world.method_8419() && random.method_43048(30 - (int)(10.0f * downfall)) == 0) {
            long time = world.method_8532();
            float temp = biome.method_8712();
            if (time >= 12000L && time <= 23000L && (double)temp >= 0.5 && temp < 1.0f) {
                world.method_8406((class_2394)FIREFLY, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnDoubleBubbles(class_2394 particle, class_1937 world, class_2338 pos, class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            case field_11043: {
                xLen = true;
                if (chestType != class_2745.field_12571) break;
                xOffset = -1;
                break;
            }
            case field_11035: {
                xLen = true;
                if (chestType != class_2745.field_12574) break;
                xOffset = -1;
                break;
            }
            case field_11034: {
                zLen = true;
                if (chestType != class_2745.field_12571) break;
                zOffset = -1;
                break;
            }
            case field_11039: {
                zLen = true;
                if (chestType != class_2745.field_12574) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
            double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)zLen) + (double)zOffset;
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnChestBubbles(class_2394 particle, class_1937 world, class_2338 pos) {
        for (int i = 0; i < 10; ++i) {
            Main.spawnBubble(particle, world, pos);
        }
    }

    public static void spawnDoubleChestBubbles(class_2394 particle, class_1937 world, class_2338 pos, class_2680 state) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2741.field_12506);
        boolean xLen = false;
        boolean zLen = false;
        int xOffset = 0;
        int zOffset = 0;
        switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
            case field_11043: {
                xLen = true;
                if (chestType != class_2745.field_12571) break;
                xOffset = -1;
                break;
            }
            case field_11035: {
                xLen = true;
                if (chestType != class_2745.field_12574) break;
                xOffset = -1;
                break;
            }
            case field_11034: {
                zLen = true;
                if (chestType != class_2745.field_12571) break;
                zOffset = -1;
                break;
            }
            case field_11039: {
                zLen = true;
                if (chestType != class_2745.field_12574) break;
                zOffset = -1;
            }
        }
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.method_10263() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)xLen) + (double)xOffset;
            double y = (double)pos.method_10264() + 0.25 + world.field_9229.method_43058() * 0.5;
            double z = (double)pos.method_10260() + 0.25 + world.field_9229.method_43058() * (0.5 + (double)zLen) + (double)zOffset;
            world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static {
        cascades = new Hashtable();
        fireflyFrequency = 1.0f;
    }
}

