/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.panorama_screen;

import java.util.Arrays;
import java.util.List;
import me.juancarloscp52.panorama_screen.PanoramaScreens;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;

public class Settings {
    private static final List<Class<? extends Screen>> MINECRAFT_IGNORED_SCREENS = Arrays.asList(TitleScreen.class, PackSelectionScreen.class, SocialInteractionsScreen.class);
    public static final List<String> PANORAMA_ALLOW_LIST = Arrays.asList("net.minecraft.", "net.optifine.gui.", "quark.base.client", "shedaniel.clothconfig2.gui.", "bumblesoftware.fastload.client", "fuzs.configmenusforge.client", "jellysquid.mods.sodium.client.", "reeses_sodium_options.client", "blamejared.controlling", "mc.ipnext.gui", "me.juancarloscp52.spyglass_improvements.client", "dev.tr7zw.skinlayers.", "mcp.mobius.waila.gui.", "dqu.additionaladditions.config", "bclib.client.gui.", "cominixo.betterf3.config.gui", "pepperbell.continuity.client.config", "redlimerl.detailab.screen", "kyrptonaught.kyrptconfig.config.screen", "megane.runtime.config.screen", "terraformersmc.modmenu.gui.ModMenuOptionsScreen", "yalter.mousetweaks.ConfigScreen", "dev.tr7zw.notenoughanimations.", "ha3.presencefootsteps.", "shedaniel.rei.impl.client.gui.credits.", "xaero.common.gui.", "xaero.map.gui.", "juuxel.adorn.client.gui.screen.", "net.puzzlemc.gui.screen.", "midnightdust.core.screen.", "midnightdust.lib.config.", "betternether.config.screen", "minenash.enhanced_attack_indicator.config.", "jamalam360.jamlib.config.", "darkhax.tipsmod.impl.gui.", "natamus.collective_common_forge.config.", "natamus.collective_common_fabric.config.", "natamus.collective.fabric.config", "natamus.collective.forge.config", "izofar.takesapillage.client.gui", "snownee.jade.gui.", "chunksfadein.gui.", "colormatic.", "deepslatecutting.config.", "nicerskies.gui.", "pingwheel.client.", "corail.tombstone.gui", "fpsreducer.gui.", "moreoverlays.gui.", "minecraftforge.client.gui.config.", ".computercraft.", "ctm.client.config", "healthoverlay.config.", ".cotton.gui.impl.modmenu.", "spell_engine.client.gui.", "catalogue.client.", "bisecthosting.mods.bhmenu", "oauth.gui.", "borderless.client.", "borderlessmining.config", "languagereload.config.", "ftbauxilium.screens.", "advancednetherite.client.", "minetogether.orderform.screen.", "minetogether.chat.gui.MutedUsersScreen", "minetogether.gui.SettingsScreen", "configured.client", "voicechat.gui.VoiceChatSettingsScreen");
    public static final List<String> PANORAMA_BLOCK_LIST = Arrays.asList("net.optifine.shaders.gui.");
    public boolean printScreenNames = false;
    public List<String> panoramaAllowList = PANORAMA_ALLOW_LIST;
    public List<String> panoramaBlockList = PANORAMA_BLOCK_LIST;

    public boolean shouldApplyToObject(String classname) {
        if (null == classname || classname.trim().isEmpty()) {
            return false;
        }
        boolean onWhitelist = false;
        for (String allowedClass : this.panoramaAllowList) {
            if (!classname.toLowerCase().contains(allowedClass.toLowerCase().trim())) continue;
            onWhitelist = true;
            break;
        }
        if (!onWhitelist) {
            return false;
        }
        for (String blockedClass : this.panoramaBlockList) {
            if (!classname.toLowerCase().contains(blockedClass.toLowerCase().trim())) continue;
            return false;
        }
        return true;
    }

    public boolean shouldApplyToScreen(Screen screen) {
        if (screen != null) {
            if (MINECRAFT_IGNORED_SCREENS.contains(screen.getClass())) {
                return false;
            }
            if (screen.getClass().equals(LanguageSelectScreen.class) && PanoramaScreens.isLanguageReloadLoaded) {
                return false;
            }
            return this.shouldApplyToObject(screen.getClass().getName());
        }
        return false;
    }
}

