/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.panorama_screen;

import com.google.gson.Gson;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.juancarloscp52.panorama_screen.Settings;
import org.slf4j.Logger;

public class PanoramaScreens {
    public static final String MOD_ID = "panorama_screens";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Settings settings;
    public static boolean isLanguageReloadLoaded;

    public static void init() {
        PanoramaScreens.loadSettings();
    }

    public static void loadSettings() {
        File file = new File("./config/panorama_screens/settings.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                settings = (Settings)gson.fromJson((Reader)fileReader, Settings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load bedrockIfy settings: " + e.getLocalizedMessage());
            }
        } else {
            settings = new Settings();
            PanoramaScreens.saveSettings();
        }
    }

    public static void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/panorama_screens/settings.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save bedrockIfy settings: " + e.getLocalizedMessage());
        }
    }

    static {
        isLanguageReloadLoaded = false;
    }
}

