/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.paladins.PaladinsMod;
import net.paladins.config.ShieldsConfig;
import net.paladins.config.TweaksConfig;
import net.paladins.item.Group;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.Weapon;

public class Shields {
    public static final class_2960 equipSoundId = new class_2960("paladins", "shield_equip");
    public static final class_3414 equipSound = class_3414.method_47908((class_2960)equipSoundId);
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    private static final String GENERIC_ARMOR_TOUGHNESS = "minecraft:generic.armor_toughness";
    private static final String GENERIC_MAX_HEALTH = "generic.max_health";
    private static final int durability_t0 = 168;
    private static final int durability_t1 = 336;
    private static final int durability_t2 = 672;
    private static final int durability_t3 = 1344;
    private static final int durability_t4 = 1344;
    public static Entry iron_kite_shield = Shields.shield("iron_kite_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620}), List.of(new ItemConfig.Attribute("minecraft:generic.armor_toughness", 1.0f, class_1322.class_1323.field_6328), new ItemConfig.Attribute("generic.max_health", 2.0f, class_1322.class_1323.field_6328)), 336);
    public static Entry golden_kite_shield = Shields.shield("golden_kite_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695}), List.of(), 168);
    public static Entry diamond_kite_shield = Shields.shield("diamond_kite_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), List.of(new ItemConfig.Attribute("minecraft:generic.armor_toughness", 1.0f, class_1322.class_1323.field_6328), new ItemConfig.Attribute("generic.max_health", 2.0f, class_1322.class_1323.field_6328)), 672);
    public static Entry netherite_kite_shield = Shields.shield("netherite_kite_shield", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), List.of(new ItemConfig.Attribute("minecraft:generic.armor_toughness", 1.0f, class_1322.class_1323.field_6328), new ItemConfig.Attribute("generic.max_health", 4.0f, class_1322.class_1323.field_6328)), 1344);
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";

    private static Supplier<class_1856> ingredient(String idString, boolean requirement, class_1792 fallback) {
        class_2960 id = new class_2960(idString);
        if (requirement) {
            return () -> class_1856.method_8091((class_1935[])new class_1935[]{fallback});
        }
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    public static Entry shield(String name, Supplier<class_1856> repair, List<ItemConfig.Attribute> attributes, int durability) {
        Entry entry = new Entry(new class_2960("paladins", name), repair, attributes, durability);
        ENTRIES.add(entry);
        return entry;
    }

    public static void register(Map<String, ShieldsConfig.Entry> configs) {
        Supplier<class_1856> repair;
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Shields.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), class_1802.field_22020);
            Shields.shield("ruby_kite_shield", repair, List.of(new ItemConfig.Attribute(GENERIC_ARMOR_TOUGHNESS, 1.0f, class_1322.class_1323.field_6328), new ItemConfig.Attribute(GENERIC_MAX_HEALTH, 6.0f, class_1322.class_1323.field_6328)), 1344);
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = Shields.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), class_1802.field_22020);
            Shields.shield("aeternium_kite_shield", repair, List.of(new ItemConfig.Attribute(GENERIC_ARMOR_TOUGHNESS, 1.0f, class_1322.class_1323.field_6328), new ItemConfig.Attribute(GENERIC_MAX_HEALTH, 6.0f, class_1322.class_1323.field_6328)), 1344);
        }
        ArrayList<CustomShieldItem> shields = new ArrayList<CustomShieldItem>();
        for (Entry entry : ENTRIES) {
            ShieldsConfig.Entry config = configs.get(entry.id.toString());
            if (config == null) {
                config = new ShieldsConfig.Entry();
                config.durability = entry.durability;
                config.attributes = entry.attributes;
                configs.put(entry.id.toString(), config);
            }
            ArrayList<class_3545> shieldAttributes = new ArrayList<class_3545>();
            for (Map.Entry attributeEntry : Weapon.attributesFrom(config.attributes).entrySet()) {
                shieldAttributes.add(new class_3545((Object)((class_1320)attributeEntry.getKey()), (Object)((class_1322)attributeEntry.getValue())));
            }
            CustomShieldItem shield = new CustomShieldItem(equipSound, entry.repair, shieldAttributes, (class_1792.class_1793)new FabricItemSettings().maxDamage(config.durability));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)shield);
            shields.add(shield);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (class_1792 shield : shields) {
                content.method_45421((class_1935)shield);
            }
        });
    }

    public record Entry(class_2960 id, Supplier<class_1856> repair, List<ItemConfig.Attribute> attributes, int durability) {
    }
}

