/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import com.google.gson.JsonObject;
import com.obscuria.obscureapi.api.common.classes.Ability;
import com.obscuria.obscureapi.api.utils.Icons;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class TextUtils {
    public static final Style ICONS = Style.f_131099_.m_131150_(new ResourceLocation("obscure_api", "icons"));

    public static MutableComponent component(String text) {
        return Component.m_237113_((String)text).m_130948_(ICONS);
    }

    public static MutableComponent translatableComponent(String text) {
        return Component.m_237115_((String)text).m_130948_(ICONS);
    }

    public static String translation(String text) {
        return Component.m_237115_((String)text).m_130948_(ICONS).getString();
    }

    public static List<Component> buildTooltip(int lineWight, String text, String lineStart) {
        return TextUtils.buildTooltip(new ArrayList<Component>(), lineWight, text, lineStart, lineStart);
    }

    public static List<Component> buildTooltip(int lineWight, String text, String firstLineStart, String lineStart) {
        return TextUtils.buildTooltip(new ArrayList<Component>(), lineWight, text, firstLineStart, lineStart);
    }

    public static List<Component> buildTooltip(List<Component> list, int lineWight, String text, String lineStart) {
        return TextUtils.buildTooltip(list, lineWight, text, lineStart, lineStart);
    }

    public static List<Component> buildTooltip(List<Component> list, int lineWight, String text, String firstLineStart, String lineStart) {
        String[] words = TextUtils.format(text).split(" ");
        StringBuilder line = new StringBuilder(firstLineStart);
        int index = 0;
        for (String word : words) {
            if (++index >= words.length) {
                if (TextUtils.length(line, word) > lineWight) {
                    list.add((Component)TextUtils.component(line.toString()));
                    list.add((Component)TextUtils.component(lineStart + word));
                    continue;
                }
                list.add((Component)TextUtils.component(line.append(word).toString()));
                continue;
            }
            if (word.equals(">")) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(lineStart);
                continue;
            }
            if (TextUtils.length(line) > 2 && TextUtils.length(line, word) > lineWight) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(lineStart);
            }
            line.append(word).append(" ");
        }
        return list;
    }

    public static List<Component> buildLore(int lineWight, String text, String lineStart) {
        return TextUtils.buildLore(new ArrayList<Component>(), lineWight, text, lineStart);
    }

    public static List<Component> buildLore(List<Component> list, int lineWight, String text) {
        return TextUtils.buildLore(list, lineWight, text, "");
    }

    public static List<Component> buildLore(List<Component> list, int lineWight, String text, String lineStart) {
        String[] words = TextUtils.format(text).split(" ");
        StringBuilder line = new StringBuilder(lineStart + "\u00a77");
        int index = 0;
        for (String word : words) {
            if (++index >= words.length) {
                if (TextUtils.length(line, word) > lineWight) {
                    list.add((Component)TextUtils.component(line.toString()));
                    list.add((Component)TextUtils.component(lineStart + "\u00a77" + word));
                    continue;
                }
                list.add((Component)TextUtils.component(line.append(word).toString()));
                continue;
            }
            if (word.equals(">")) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(lineStart + "\u00a77");
                continue;
            }
            if (TextUtils.length(line) > 2 && TextUtils.length(line, word) > lineWight) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(lineStart + "\u00a77");
            }
            line.append(word).append(" ");
        }
        return list;
    }

    public static List<Component> buildKnowledge(int lineWight, String text) {
        return TextUtils.buildKnowledge(new ArrayList<Component>(), lineWight, text);
    }

    public static List<Component> buildKnowledge(List<Component> list, int lineWight, String text) {
        String[] words = TextUtils.format(text).split(" ");
        list.add((Component)TextUtils.component(TextUtils.translation("tooltip.key.knowledge")));
        StringBuilder line = new StringBuilder("\u00a79   ");
        int index = 0;
        for (String word : words) {
            if (++index >= words.length) {
                if (TextUtils.length(line, word) > lineWight) {
                    list.add((Component)TextUtils.component(line.toString()));
                    list.add((Component)TextUtils.component("\u00a79   " + word));
                    continue;
                }
                list.add((Component)TextUtils.component(line.append(word).toString()));
                continue;
            }
            if (word.equals(">")) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder("\u00a79   ");
                continue;
            }
            if (TextUtils.length(line) > 2 && TextUtils.length(line, word) > lineWight) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder("\u00a79   ");
            }
            line.append(word).append(" ");
        }
        return list;
    }

    public static List<Component> buildAbility(int lineWight, Ability ability, Player player) {
        return TextUtils.buildAbility(new ArrayList<Component>(), lineWight, ability, player);
    }

    public static List<Component> buildAbility(List<Component> list, int lineWight, Ability ability, Player player) {
        boolean title = true;
        Ability.Style style = ability.getStyle();
        String text = TextUtils.format(TextUtils.translation(ability.getDescriptionId()));
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder(Icons.STICK.get() + style.TITLE);
        int index = 0;
        for (String word : words) {
            word = word.replace("{#1}", ability.getVariableString((LivingEntity)player, 1) + ability.getVariableTypeString(1) + style.LINE).replace("{#2}", ability.getVariableString((LivingEntity)player, 2) + ability.getVariableTypeString(2) + style.LINE).replace("{#3}", ability.getVariableString((LivingEntity)player, 3) + ability.getVariableTypeString(3) + style.LINE);
            if (++index >= words.length) {
                if (TextUtils.length(line, word) > lineWight) {
                    list.add((Component)TextUtils.component(line.toString()));
                    list.add((Component)TextUtils.component(Icons.STICK.get() + " " + style.LINE + word));
                    continue;
                }
                list.add((Component)TextUtils.component(line.append(word).toString()));
                continue;
            }
            if (word.equals(">")) {
                if (title) {
                    line.append(ability.getCostString((LivingEntity)player));
                    title = false;
                }
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(Icons.STICK.get() + " " + style.LINE);
                continue;
            }
            if (!title && TextUtils.length(line) > 2 && TextUtils.length(line, word) > lineWight) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(Icons.STICK.get() + " " + style.LINE);
            }
            line.append(word).append(" ");
        }
        return list;
    }

    public static List<Component> buildPerk(int lineWight, ResourceLocation registry) {
        return TextUtils.buildPerk(new ArrayList<Component>(), lineWight, registry);
    }

    public static List<Component> buildPerk(List<Component> list, int lineWight, ResourceLocation registry) {
        String text = TextUtils.format(TextUtils.translation("perk." + registry.m_135827_() + "." + registry.m_135815_() + ".desc"));
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder(Icons.STICK.get() + "\u00a7f");
        int index = 0;
        for (String word : words) {
            if (++index >= words.length) {
                if (TextUtils.length(line, word) > lineWight) {
                    list.add((Component)TextUtils.component(line.toString()));
                    list.add((Component)TextUtils.component(Icons.STICK.get() + " \u00a77" + word));
                    continue;
                }
                list.add((Component)TextUtils.component(line.append(word).toString()));
                continue;
            }
            if (word.equals(">")) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(Icons.STICK.get() + " \u00a77");
                continue;
            }
            if (TextUtils.length(line) > 2 && TextUtils.length(line, word) > lineWight) {
                list.add((Component)TextUtils.component(line.toString()));
                line = new StringBuilder(Icons.STICK.get() + " \u00a77");
            }
            line.append(word).append(" ");
        }
        return list;
    }

    public static int length(StringBuilder builder) {
        return TextUtils.length(builder.toString());
    }

    public static int length(StringBuilder builder, String other) {
        return TextUtils.length(builder) + TextUtils.length(other);
    }

    public static int length(String string, String other) {
        return TextUtils.length(string) + TextUtils.length(other);
    }

    public static int length(String string) {
        if (string.length() < 2) {
            return string.length();
        }
        for (ChatFormatting chatFormatting : ChatFormatting.values()) {
            string = string.replace("\u00a7" + chatFormatting.m_178510_(), "");
        }
        return string.length();
    }

    public static String getString(JsonObject jsonObject, String element) {
        return jsonObject.has(element) ? jsonObject.get(element).getAsString() : "null";
    }

    public static String format(String text) {
        return text.replace("{#}", " > ").replace("{BR}", " > ").replace("{BLACK}", "\u00a70").replace("{WHITE}", "\u00a7f").replace("{GRAY}", "\u00a77").replace("{DARK_GRAY}", "\u00a78").replace("{GOLD}", "\u00a76").replace("{GREEN}", "\u00a7a").replace("{DARK_GREEN}", "\u00a72").replace("{RED}", "\u00a7c").replace("{BLUE}", "\u00a79").replace("{I}", "\u00a7f" + Icons.INFO.get()).replace("{U}", "\u00a7f" + Icons.RMB.get()).replace("{B}", "\u00a7f" + Icons.BOSS.get()).replace("{H1}", "\u00a7f" + Icons.HEART.get()).replace("{H2}", "\u00a7f" + Icons.HEART_HALF.get()).replace("{H3}", "\u00a7f" + Icons.HEART_EMPTY.get());
    }

    public static String format(JsonObject jsonObject, String element) {
        return jsonObject.has(element) ? TextUtils.format(jsonObject.get(element).getAsString()) : "null";
    }
}

