/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import com.obscuria.obscureapi.api.utils.UnsafeRunnable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RenderUtils {
    public static void screen(ResourceLocation shader, UnsafeRunnable runnable) {
        RenderUtils.screen(shader, 1.0f, 1.0f, 1.0f, runnable);
    }

    public static void screen(ResourceLocation shader, float r, float g, float b, UnsafeRunnable runnable) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)shader);
        ExceptionFilter.of(runnable);
    }

    public static void screenBlend(ResourceLocation shader, UnsafeRunnable runnable) {
        RenderUtils.screenBlend(shader, 1.0f, 1.0f, 1.0f, 1.0f, runnable);
    }

    public static void screenBlend(ResourceLocation shader, float alpha, UnsafeRunnable runnable) {
        RenderUtils.screenBlend(shader, 1.0f, 1.0f, 1.0f, alpha, runnable);
    }

    public static void screenBlend(ResourceLocation shader, float r, float g, float b, float alpha, UnsafeRunnable runnable) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)shader);
        RenderSystem.enableBlend();
        ExceptionFilter.of(runnable);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void screenDepth(ResourceLocation shader, UnsafeRunnable runnable) {
        RenderUtils.screenDepth(shader, 1.0f, 1.0f, 1.0f, runnable);
    }

    public static void screenDepth(ResourceLocation shader, float r, float g, float b, UnsafeRunnable runnable) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)shader);
        RenderSystem.enableDepthTest();
        ExceptionFilter.of(runnable);
        RenderSystem.disableDepthTest();
    }

    public static void screenBlendDepth(ResourceLocation shader, UnsafeRunnable runnable) {
        RenderUtils.screenBlendDepth(shader, 1.0f, 1.0f, 1.0f, 1.0f, runnable);
    }

    public static void screenBlendDepth(ResourceLocation shader, float alpha, UnsafeRunnable runnable) {
        RenderUtils.screenBlendDepth(shader, 1.0f, 1.0f, 1.0f, alpha, runnable);
    }

    public static void screenBlendDepth(ResourceLocation shader, float r, float g, float b, float alpha, UnsafeRunnable runnable) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)shader);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        ExceptionFilter.of(runnable);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }
}

