/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.upload;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class LegacyCrashLogUpload {
    private static final String GIST_ACCESS_TOKEN = LegacyCrashLogUpload.GIST_ACCESS_TOKEN_PART_1() + LegacyCrashLogUpload.GIST_ACCESS_TOKEN_PART_2();

    private static String GIST_ACCESS_TOKEN_PART_1() {
        return "dc07dacff0c2cf84f706";
    }

    private static String GIST_ACCESS_TOKEN_PART_2() {
        return "8ac0fd6a757d53b81233";
    }

    public static String upload(String text) throws IOException {
        return LegacyCrashLogUpload.uploadToByteBin(text);
    }

    private static String uploadToByteBin(String text) throws IOException {
        String url = "https://bytebin.lucko.me/";
        HttpPost post = new HttpPost(url + "post");
        String userAgent = String.join((CharSequence)" ", Arrays.toString(post.getHeaders("User-Agent"))).concat(" NotEnoughCrashes");
        post.setHeader("User-Agent", userAgent);
        post.addHeader("Content-Type", "text/plain");
        post.setEntity((HttpEntity)LegacyCrashLogUpload.createStringEntity(text));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseJson = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            String bytebinKey = responseJson.getAsJsonPrimitive("key").getAsString();
            String string = url + bytebinKey;
            return string;
        }
    }

    private static StringEntity createStringEntity(String text) {
        return new StringEntity(text, StandardCharsets.UTF_16);
    }

    private static class GistFile {
        public String content;

        public GistFile(String content) {
            this.content = content;
        }
    }

    private static class GistPost {
        @SerializedName(value="public")
        public boolean isPublic;
        public Map<String, GistFile> files;

        public GistPost(boolean isPublic, Map<String, GistFile> files) {
            this.isPublic = isPublic;
            this.files = files;
        }
    }
}

