/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.block;

import com.starfish_studios.naturalist.common.entity.Snail;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SnailEggBlock
extends Block {
    public static float HITBOX_WIDTH = 0.4f;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);

    public SnailEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.m_186460_(pos, (Block)this, SnailEggBlock.getSnailEggHatchDelay(level.m_213780_()));
    }

    private static int getSnailEggHatchDelay(RandomSource random) {
        int minHatchTickDelay = 600;
        int maxHatchTickDelay = 2400;
        return random.m_216339_(minHatchTickDelay, maxHatchTickDelay);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.hatchSnailEgg(level, pos, random);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20450_)) {
            this.destroyBlock(level, pos);
        }
    }

    private void hatchSnailEgg(ServerLevel level, BlockPos pos, RandomSource random) {
        this.destroyBlock((Level)level, pos);
        level.m_5594_(null, pos, SoundEvents.f_215687_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.spawnBabySnails(level, pos, random);
    }

    private void destroyBlock(Level level, BlockPos pos) {
        level.m_46961_(pos, false);
    }

    private void spawnBabySnails(ServerLevel level, BlockPos pos, RandomSource random) {
        int i = random.m_216339_(2, 6);
        for (int j = 1; j <= i; ++j) {
            Snail snail = (Snail)NaturalistEntityTypes.SNAIL.get().m_20615_((Level)level);
            if (snail == null) continue;
            double d = (double)pos.m_123341_() + this.getRandomSnailPositionOffset(random);
            double e = (double)pos.m_123343_() + this.getRandomSnailPositionOffset(random);
            int k = random.m_216339_(1, 361);
            snail.m_7678_(d, pos.m_123342_(), e, k, 0.0f);
            snail.m_21530_();
            snail.m_146762_(-6000);
            level.m_7967_((Entity)snail);
        }
    }

    private double getRandomSnailPositionOffset(RandomSource random) {
        double d = HITBOX_WIDTH / 2.0f;
        return Mth.m_14008_((double)random.m_188500_(), (double)d, (double)(1.0 - d));
    }
}

