/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.render.item.RenderGeomancerArmor;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.MowzieArmorItem;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemGeomancerArmor
extends MowzieArmorItem
implements GeoItem {
    private static final GeomancerArmorMaterial GEOMANCER_ARMOR_MATERIAL = new GeomancerArmorMaterial();
    public String controllerName = "controller";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ItemGeomancerArmor(ArmorItem.Type slot, Item.Properties builderIn) {
        super(GEOMANCER_ARMOR_MATERIAL, slot, builderIn);
    }

    @Override
    public ConfigHandler.ArmorConfig getConfig() {
        return ConfigHandler.COMMON.TOOLS_AND_ABILITIES.GEOMANCER_ARMOR.armorConfig;
    }

    private PlayState predicate(AnimationState<ItemGeomancerArmor> state) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this.controllerName, 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".text.0")).m_6270_(ItemHandler.TOOLTIP_STYLE));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> armorRenderer;

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.armorRenderer == null) {
                    this.armorRenderer = new RenderGeomancerArmor();
                }
                this.armorRenderer.prepForRender((Entity)entityLiving, itemStack, equipmentSlot, original);
                return this.armorRenderer;
            }
        });
    }

    private static class GeomancerArmorMaterial
    implements ArmorMaterial {
        private GeomancerArmorMaterial() {
        }

        public int m_266425_(ArmorItem.Type equipmentSlotType) {
            return ArmorMaterials.DIAMOND.m_266425_(equipmentSlotType);
        }

        public int m_7366_(ArmorItem.Type equipmentSlotType) {
            return (int)((float)ArmorMaterials.DIAMOND.m_7366_(equipmentSlotType) * ConfigHandler.COMMON.TOOLS_AND_ABILITIES.GEOMANCER_ARMOR.armorConfig.damageReductionMultiplierValue);
        }

        public int m_6646_() {
            return ArmorMaterials.DIAMOND.m_6646_();
        }

        public SoundEvent m_7344_() {
            return ArmorMaterials.DIAMOND.m_7344_();
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemHandler.BLUFF_ROD.get()});
        }

        public String m_6082_() {
            return "geomancer_armor";
        }

        public float m_6651_() {
            return ArmorMaterials.DIAMOND.m_6651_() * ConfigHandler.COMMON.TOOLS_AND_ABILITIES.WROUGHT_HELM.armorConfig.toughnessMultiplierValue;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

