/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityEarthSpike;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class EntityBoulderProjectile
extends EntityBoulderBase {
    protected final List<Entity> ridingEntities = new ArrayList<Entity>();
    protected boolean travelling = false;
    protected float speed = 1.5f;
    protected int damage = 10;
    private boolean didShootParticles = false;
    private static final EntityDataAccessor<Vector3f> SHOOT_DIRECTION = SynchedEntityData.m_135353_(EntityBoulderProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);

    public EntityBoulderProjectile(EntityType<? extends EntityBoulderProjectile> type, Level world) {
        super((EntityType<? extends EntityBoulderBase>)type, world);
    }

    public EntityBoulderProjectile(EntityType<? extends EntityBoulderProjectile> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos, EntityGeomancyBase.GeomancyTier tier) {
        super(type, world, caster, blockState, pos, tier);
    }

    @Override
    public void setSizeParams() {
        super.setSizeParams();
        EntityGeomancyBase.GeomancyTier size = this.getTier();
        if (size == EntityGeomancyBase.GeomancyTier.MEDIUM) {
            this.damage = 14;
            this.speed = 1.4f;
        } else if (size == EntityGeomancyBase.GeomancyTier.LARGE) {
            this.damage = 18;
            this.speed = 1.2f;
        } else if (size == EntityGeomancyBase.GeomancyTier.HUGE) {
            this.damage = 25;
            this.speed = 1.1f;
        }
        this.damage = (int)((double)this.damage * this.getDamageMult());
    }

    protected double getDamageMult() {
        if (this.getCaster() instanceof Player) {
            return (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.attackMultiplier.get();
        }
        if (this.getCaster() instanceof EntitySculptor) {
            return (Double)ConfigHandler.COMMON.MOBS.SCULPTOR.combatConfig.attackMultiplier.get();
        }
        return 1.0;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    @NotNull
    protected AABB m_142242_() {
        AABB boundingBox = super.m_142242_();
        if (this.shouldExtendBoundsDown()) {
            boundingBox = boundingBox.m_82363_(0.0, -0.5, 0.0);
        }
        return boundingBox;
    }

    protected boolean shouldExtendBoundsDown() {
        return !this.travelling;
    }

    protected void findRidingEntities() {
        if (!(this.getCaster() instanceof EntitySculptor)) {
            if (this.ridingEntities != null) {
                this.ridingEntities.clear();
            }
            List onTopOfEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82310_(0.0, (double)(this.m_20206_() - 1.0f), 0.0).m_82383_(new Vec3(0.0, (double)this.m_20206_() - 0.5, 0.0)).m_82377_(0.6, 0.5, 0.6));
            for (Entity entity : onTopOfEntities) {
                if (entity == null || !entity.m_6087_() || entity instanceof EntityBoulderProjectile || !(entity.m_20186_() >= this.m_20186_() + 0.2) || !entity.m_6094_()) continue;
                this.ridingEntities.add(entity);
            }
        }
    }

    @Override
    public void m_8119_() {
        if (this.startActive() && this.f_19797_ == 1) {
            this.activate();
        }
        super.m_8119_();
        if (this.m_9236_().m_46749_(this.m_20183_()) && !this.m_9236_().m_5776_() && (this.getCaster() == null || this.getCaster().m_213877_())) {
            this.explode();
        }
        this.findRidingEntities();
        if (this.travelling) {
            for (Entity entity : this.ridingEntities) {
                entity.m_6478_(MoverType.SHULKER_BOX, this.m_20184_().m_82520_(0.0, 0.1, 0.0));
            }
        }
        List<Entity> entitiesHit = this.getEntitiesNearby(1.7);
        if (this.travelling && !entitiesHit.isEmpty()) {
            for (Entity entity : entitiesHit) {
                if (this.m_9236_().f_46443_ || entity == this.getCaster() || entity.f_19794_ || !entity.m_271807_() || !this.travellingBlockedBy(entity) || this.ridingEntities != null && this.ridingEntities.contains(entity)) continue;
                if (this.getCaster() != null) {
                    entity.m_6469_(this.m_269291_().m_269299_((Entity)this, this.getCaster()), (float)this.damage);
                } else {
                    entity.m_6469_(this.m_269291_().m_269264_(), (float)this.damage);
                }
                if (!this.m_6084_()) continue;
                this.explode();
            }
        }
        this.handleHitOtherBoulders();
        if (this.travelling && (!this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), e -> (this.ridingEntities == null || !this.ridingEntities.contains(e)) && e.m_5829_() && this.travellingBlockedBy((Entity)e)).isEmpty() || Iterables.size((Iterable)this.m_9236_().m_186434_((Entity)this, this.m_20191_().m_82400_(0.1))) > 0)) {
            this.explode();
        }
        if (this.m_9236_().m_5776_() && ((Vector3f)this.m_20088_().m_135370_(SHOOT_DIRECTION)).length() > 0.0f && !this.didShootParticles) {
            Vec3 vec3 = new Vec3((Vector3f)this.m_20088_().m_135370_(SHOOT_DIRECTION)).m_82490_(-1.0).m_82541_();
            ParticleRotation.OrientVector rotation = new ParticleRotation.OrientVector(vec3);
            AdvancedParticleBase.spawnAlwaysVisibleParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), 64.0, (float)this.m_20185_() + (float)vec3.f_82479_, (float)this.m_20186_() + 0.5f + (float)vec3.f_82480_, (float)this.m_20189_() + (float)vec3.f_82481_, 0.0, 0.0, 0.0, rotation, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, (int)(5.0f + 2.0f * this.m_20205_()), true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, (1.0f + 0.5f * this.m_20205_()) * 8.0f * this.getShootRingParticleScale()), false)});
            this.didShootParticles = true;
        }
    }

    public List<Entity> getRidingEntities() {
        return this.ridingEntities;
    }

    protected boolean startActive() {
        return true;
    }

    protected boolean travellingBlockedBy(Entity entity) {
        if (this.getCaster() instanceof EntitySculptor) {
            if (entity instanceof EntityEarthSpike) {
                return false;
            }
            return !(entity instanceof EntityBoulderBase) || ((EntityBoulderProjectile)entity).getCaster() != this.getCaster();
        }
        return true;
    }

    public boolean m_7337_(Entity entity) {
        if (this.getCaster() instanceof EntitySculptor) {
            if (this.travelling && entity instanceof EntityEarthSpike) {
                return false;
            }
            return super.m_7337_(entity) && (!(entity instanceof EntityBoulderBase) || ((EntityBoulderProjectile)entity).getCaster() != this.getCaster());
        }
        return super.m_7337_(entity);
    }

    protected void handleHitOtherBoulders() {
        List bouldersHit = this.m_9236_().m_45976_(EntityBoulderProjectile.class, this.m_20191_().m_82377_(0.2, 0.2, 0.2).m_82383_(this.m_20184_().m_82541_().m_82490_(0.5)));
        if (this.travelling && !bouldersHit.isEmpty()) {
            for (EntityBoulderProjectile otherBoulder : bouldersHit) {
                if (otherBoulder.getCaster() != this.getCaster() || otherBoulder.travelling || !this.travellingBlockedBy(otherBoulder)) continue;
                otherBoulder.m_7313_(this);
                this.explode();
            }
        }
    }

    @Override
    public boolean m_6087_() {
        return true;
    }

    public void shoot(Vec3 shootDirection) {
        this.m_20256_(shootDirection);
        if (!this.travelling) {
            this.setDeathTime(60);
        }
        this.travelling = true;
        this.m_20011_(this.m_6095_().m_20585_(this.m_20185_(), this.m_20186_(), this.m_20189_()));
        if (this.boulderSize == EntityGeomancyBase.GeomancyTier.SMALL) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 1.3f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
        } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.MEDIUM) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 0.9f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.5f);
        } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.LARGE) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 0.5f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.3f);
            EntityCameraShake.cameraShake(this.m_9236_(), this.m_20182_(), 10.0f, 0.05f, 0, 20);
        } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.5f, 1.0f);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 0.9f);
            EntityCameraShake.cameraShake(this.m_9236_(), this.m_20182_(), 15.0f, 0.05f, 0, 20);
        }
        this.m_20088_().m_135381_(SHOOT_DIRECTION, (Object)shootDirection.m_252839_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SHOOT_DIRECTION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @Override
    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    protected float getShootRingParticleScale() {
        return 1.0f;
    }

    public boolean m_7313_(Entity entityIn) {
        if (this.risingTick > this.finishedRisingTick - 1 && !this.travelling) {
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                if (EffectGeomancy.canUse((LivingEntity)((Player)entityIn))) {
                    if (this.ridingEntities.contains(player)) {
                        Vec3 lateralLookVec = Vec3.m_82498_((float)0.0f, (float)player.m_146908_()).m_82541_();
                        this.shoot(new Vec3((double)this.speed * 0.5 * lateralLookVec.f_82479_, this.m_20184_().f_82480_, (double)this.speed * 0.5 * lateralLookVec.f_82481_));
                    } else {
                        this.shoot(player.m_20154_().m_82490_((double)this.speed * 0.5));
                    }
                    AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.HIT_BOULDER_ABILITY);
                } else if (!this.m_9236_().m_5776_() && this.getCaster() == player) {
                    this.explode();
                }
            } else if (entityIn instanceof EntityBoulderProjectile) {
                EntityBoulderProjectile boulder = (EntityBoulderProjectile)entityIn;
                if (((EntityBoulderProjectile)entityIn).travelling) {
                    Vec3 thisPos = this.m_20182_();
                    Vec3 boulderPos = boulder.m_20182_();
                    Vec3 velVec = thisPos.m_82546_(boulderPos).m_82541_();
                    this.shoot(velVec.m_82490_((double)this.speed * 0.5));
                }
            }
        }
        return super.m_7313_(entityIn);
    }

    public boolean isTravelling() {
        return this.travelling;
    }

    public void setTravelling(boolean travel) {
        this.travelling = travel;
    }

    public void setDamage(int dam) {
        this.damage = dam;
    }
}

