/*
 * Decompiled with CFR 0.152.
 */
package net.talesstudio.moboptimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.talesstudio.moboptimizer.MobOptimizerConfig;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER}, modid="moboptimizer")
public class MobAIHandler {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (!(event.level instanceof ServerLevel)) {
            return;
        }
        if (++tickCounter % (Integer)MobOptimizerConfig.TICK_INTERVAL.get() != 0) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)event.level;
        for (Player player : serverWorld.m_6907_()) {
            HashMap<Vec3, List> mobGroups = new HashMap<Vec3, List>();
            List nearbyMobs = serverWorld.m_45976_(Mob.class, player.m_20191_().m_82400_(((Double)MobOptimizerConfig.SEARCH_DISTANCE.get()).doubleValue()));
            for (Mob mob : nearbyMobs) {
                int cellX = (int)(mob.m_20185_() / (Double)MobOptimizerConfig.CELL_SIZE.get());
                int cellZ = (int)(mob.m_20189_() / (Double)MobOptimizerConfig.CELL_SIZE.get());
                Vec3 cellKey = new Vec3((double)cellX, 0.0, (double)cellZ);
                mobGroups.computeIfAbsent(cellKey, key -> new ArrayList()).add(mob);
            }
            int groupIndex = 0;
            for (Map.Entry entry : mobGroups.entrySet()) {
                if ((groupIndex + tickCounter / (Integer)MobOptimizerConfig.TICK_INTERVAL.get()) % 2 == 0) {
                    MobAIHandler.updateMobGroup((List)entry.getValue(), player);
                }
                ++groupIndex;
            }
        }
    }

    private static void updateMobGroup(List<Mob> mobGroup, Player player) {
        for (Mob mob : mobGroup) {
            double distance = mob.m_20238_(new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()));
            if (distance > (Double)MobOptimizerConfig.MAX_DISTANCE.get() * (Double)MobOptimizerConfig.MAX_DISTANCE.get()) {
                mob.m_21573_().m_26573_();
                mob.m_21557_(true);
                mob.f_19794_ = true;
                mob.m_21553_(false);
                mob.m_6710_(null);
                continue;
            }
            mob.m_21557_(false);
            mob.m_21573_().m_26569_();
            mob.f_19794_ = false;
            mob.m_21553_(true);
        }
    }
}

