/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.content.block.copper_pot;

import com.mojang.datafixers.util.Pair;
import com.sammy.minersdelight.content.block.copper_pot.CopperPotBlockEntity;
import com.sammy.minersdelight.content.block.copper_pot.CopperPotResultSlot;
import com.sammy.minersdelight.setup.MDBlocks;
import com.sammy.minersdelight.setup.MDItems;
import com.sammy.minersdelight.setup.MDMenuTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMealSlot;

public class CopperPotMenu
extends RecipeBookMenu<RecipeWrapper> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_CUP = new ResourceLocation("farmersdelight", "item/empty_container_slot_bowl");
    public final CopperPotBlockEntity blockEntity;
    public final ItemStackHandler inventory;
    private final ContainerData cookingPotData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public CopperPotMenu(int windowId, Inventory playerInventory, CopperPotBlockEntity blockEntity, ContainerData cookingPotDataIn) {
        super((MenuType)MDMenuTypes.COPPER_POT.get(), windowId);
        int column;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity.getInventory();
        this.cookingPotData = cookingPotDataIn;
        this.level = playerInventory.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 40;
        int inputStartY = 18;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 2; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 2 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new CookingPotMealSlot((IItemHandler)this.inventory, 4, 115, 28));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 5, 83, 56){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT_CUP);
            }
        });
        this.m_38897_((Slot)new CopperPotResultSlot(playerInventory.f_35978_, blockEntity, (IItemHandler)this.inventory, 6, 115, 56));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(cookingPotDataIn);
    }

    private static CopperPotBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof CopperPotBlockEntity) {
            return (CopperPotBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public CopperPotMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CopperPotMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean m_6875_(Player playerIn) {
        return CopperPotMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)MDBlocks.COPPER_POT.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 4;
        int indexContainerInput = 5;
        int indexOutput = 6;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == indexOutput) {
                if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index > indexOutput) {
                if (!(itemstack1.m_41720_() != Items.f_42399_ && itemstack1.m_41720_() != MDItems.COPPER_CUP.get() || this.m_38903_(itemstack1, indexContainerInput, indexContainerInput + 1, false))) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 0, indexMealDisplay, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.cookingPotData.m_6413_(0);
        int j = this.cookingPotData.m_6413_(1);
        return j != 0 && i != 0 ? i * 29 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.blockEntity.isHeated();
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super RecipeWrapper> recipe) {
        return recipe.m_5818_((Container)this.blockEntity.createFakeRecipeWrapper(), this.level);
    }

    public int m_6636_() {
        return 5;
    }

    public int m_6635_() {
        return 2;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 5;
    }

    public RecipeBookType m_5867_() {
        return FarmersDelight.RECIPE_TYPE_COOKING;
    }

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

