/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world;

import com.github.mim1q.minecells.network.PacketIdentifiers;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import dev.mim1q.gimm1q.screenshake.ScreenShakeUtils;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class MineCellsExplosion {
    public static void explode(class_3218 world, class_1297 grenade, class_1309 causingEntity, class_243 position, float power, float radius) {
        MineCellsExplosion.explode(world, grenade, causingEntity, position, power, radius, entity -> entity instanceof class_1657 || entity instanceof class_1321);
    }

    public static void explode(class_3218 world, class_1297 grenade, class_1309 causingEntity, class_243 position, float power, float radius, Predicate<class_1297> damagePredicate) {
        world.method_8396(null, class_2338.method_49638((class_2374)position), MineCellsSounds.EXPLOSION, class_3419.field_15251, 1.0f, 1.0f);
        MineCellsExplosion.damageEntities(world, grenade, causingEntity, position, power, radius, damagePredicate);
        ScreenShakeUtils.shakeAround((class_3218)world, (class_243)position, (float)1.0f, (int)20, (double)radius, (double)(radius * 3.0f), (String)"minecells:explosion");
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.writeDouble((double)radius);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.EXPLOSION, (class_2540)buf);
        }
    }

    protected static void damageEntities(class_3218 world, class_1297 grenade, class_1309 attacker, class_243 pos, float power, float radius, Predicate<class_1297> damagePredicate) {
        class_238 box = new class_238(pos.field_1352 - (double)radius, pos.field_1351 - (double)radius, pos.field_1350 - (double)radius, pos.field_1352 + (double)radius, pos.field_1351 + (double)radius, pos.field_1350 + (double)radius);
        List entities = world.method_8390(class_1309.class, box, damagePredicate);
        for (class_1309 entity : entities) {
            float distance = class_3532.method_15355((float)((float)entity.method_5707(pos)));
            if (!(distance <= radius)) continue;
            float damage = power * MineCellsExplosion.getDamagePercentage(distance, radius);
            entity.method_5643(world.method_48963().method_48819(grenade, (class_1297)attacker), damage);
        }
    }

    protected static float getDamagePercentage(float distance, float radius) {
        float minRadius = radius * 0.5f;
        if (distance <= minRadius) {
            return 1.0f;
        }
        return 1.0f - (distance - minRadius) / (radius - minRadius);
    }
}

