/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.bow;

import com.github.mim1q.minecells.entity.damage.MineCellsDamageSource;
import com.github.mim1q.minecells.item.weapon.interfaces.CritIndicator;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import com.github.mim1q.minecells.util.TextUtils;
import dev.mim1q.gimm1q.screenshake.ScreenShakeUtils;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import org.jetbrains.annotations.Nullable;

public class LightningBoltItem
extends class_1792
implements CritIndicator {
    private static final int MAX_USE_TIME = 72000;
    private static final double SELECT_DISTANCE = 6.0;
    private static final double MAX_DISTANCE = 12.0;

    public LightningBoltItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.field_9236 || !user.method_31747()) {
            return;
        }
        class_1309 entity = LightningBoltItem.getTargetedEntity(stack, world);
        if (entity == null) {
            user.method_6075();
            return;
        }
        int ticks = this.method_7881(stack) - remainingUseTicks;
        float damage = 2.0f;
        int intensity = 0;
        if (ticks > 20) {
            damage = 3.0f;
            intensity = 1;
        }
        if (ticks > 40) {
            damage = 4.0f;
            intensity = 2;
        }
        if (ticks > 60) {
            damage = 6.0f;
            intensity = 3;
        }
        if (ticks % 5 == 0) {
            ScreenShakeUtils.applyShake((class_3222)((class_3222)user), (float)(0.33f * (float)intensity), (int)20, (String)"minecells:weapon_lightning_bolt");
        }
        if (ticks % 10 == 0) {
            if (ticks > 40) {
                world.method_8396(null, user.method_24515(), MineCellsSounds.CRIT, user.method_5634(), 0.4f, 1.0f);
            }
            stack.method_7956(1, user, e -> e.method_20236(user.method_6058()));
            entity.method_5643(MineCellsDamageSource.ELECTRICITY.get(world, (class_1297)user), damage);
            if (intensity > 0) {
                entity.method_6092(new class_1293(MineCellsStatusEffects.ELECTRIFIED, 20 + 20 * intensity, intensity, false, false, true));
            }
            if (ticks > 60) {
                user.method_5643(world.method_48963().method_48831(), 1.0f);
            }
            world.method_8396(null, user.method_24515(), MineCellsSounds.SHOCKER_RELEASE, user.method_5634(), 0.2f, 1.0f);
        }
        if (ticks % 3 == 0) {
            int color = LightningBoltItem.getLightningColor(ticks);
            class_243 userPos = user.method_19538().method_1031(0.0, (double)user.method_17682() / 2.0, 0.0);
            class_243 direction = entity.method_19538().method_1031(0.0, (double)entity.method_17682() / 2.0, 0.0).method_1020(userPos);
            ((class_3218)world).method_14199((class_2394)MineCellsParticles.ELECTRICITY.get(direction, (int)direction.method_1033(), color, 1.0f), userPos.method_10216(), userPos.method_10214(), userPos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        super.method_7840(stack, world, user, remainingUseTicks);
        if (world.field_9236) {
            return;
        }
        LightningBoltItem.setTargetedEntity(stack, null);
        ((class_1657)user).method_7357().method_7906((class_1792)this, 20);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (LightningBoltItem.getTargetedEntity(user.method_5998(hand), world) == null) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        double length;
        class_243 direction;
        class_243 endPos;
        super.method_7888(stack, world, entity, slot, selected);
        if (world.field_9236 || !entity.method_31747()) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (!selected || player.method_7357().method_7904((class_1792)this)) {
            LightningBoltItem.setTargetedEntity(stack, null);
            return;
        }
        class_243 startPos = entity.method_19538().method_1031(0.0, (double)entity.method_17682() / 2.0, 0.0);
        class_3965 blockRaycast = world.method_17742(new class_3959(startPos, endPos = startPos.method_1019((direction = entity.method_5720()).method_1021(length = 6.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        if (blockRaycast.method_17783() != class_239.class_240.field_1333) {
            length = blockRaycast.method_17784().method_1022(startPos);
        }
        class_1309 selectedEntity = null;
        for (double delta = 1.0; delta <= length; delta += 0.5) {
            class_243 pos = startPos.method_1019(direction.method_1021(delta));
            class_238 box = class_238.method_30048((class_243)pos, (double)1.0, (double)1.0, (double)1.0);
            List entities = world.method_8390(class_1309.class, box, it -> it != entity);
            if (entities.isEmpty()) continue;
            selectedEntity = (class_1309)entities.get(0);
            break;
        }
        if (selectedEntity == null) {
            class_1309 currentTarget = LightningBoltItem.getTargetedEntity(stack, world);
            if (currentTarget == null) {
                return;
            }
            if (!player.method_6115() || (double)currentTarget.method_5739((class_1297)player) > 12.0) {
                LightningBoltItem.setTargetedEntity(stack, null);
            }
            return;
        }
        LightningBoltItem.setTargetedEntity(stack, selectedEntity);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    private static void setTargetedEntity(class_1799 stack, @Nullable class_1309 entity) {
        stack.method_7948().method_10569("targetId", entity == null ? -1 : entity.method_5628());
    }

    public static class_1309 getTargetedEntity(class_1799 stack, class_1937 world) {
        int id = stack.method_7948().method_10550("targetId");
        return id == -1 ? null : (class_1309)world.method_8469(stack.method_7948().method_10550("targetId"));
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public static int getLightningColor(int ticks) {
        if (ticks > 60) {
            return 16750988;
        }
        if (ticks > 40) {
            return 16763047;
        }
        if (ticks > 20) {
            return 0xF5FFBB;
        }
        return 12503039;
    }

    @Override
    public boolean shouldShowCritIndicator(@Nullable class_1657 player, @Nullable class_1309 target, class_1799 stack) {
        return player != null && player.method_6048() > 40;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        TextUtils.addDescription(tooltip, this.method_7876() + ".description", new Object[0]);
    }
}

