/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.item.weapon.interfaces.CrittingWeapon;
import com.github.mim1q.minecells.item.weapon.interfaces.WeaponWithAbility;
import com.github.mim1q.minecells.network.c2s.UseTentacleWeaponC2SPacket;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class TentacleItem
extends class_1829
implements WeaponWithAbility,
CrittingWeapon {
    public class_239 hitResult = null;

    public TentacleItem(int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(MineCellsItems.CELL_INFUSED_STEEL_MATERIAL, attackDamage, attackSpeed, settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236 && hand == class_1268.field_5808 && this.hitResult != null && this.hitResult.method_17783() != class_239.class_240.field_1333) {
            class_243 pos = this.hitResult.method_17784();
            if (this.hitResult.method_17783() == class_239.class_240.field_1331) {
                class_1297 targetEntity = ((class_3966)this.hitResult).method_17782();
                pos = targetEntity.method_19538().method_1031(0.0, (double)targetEntity.method_17682() / 2.0, 0.0);
            }
            if (this.hitResult.method_17783() == class_239.class_240.field_1332) {
                pos = ((class_3965)this.hitResult).method_17777().method_46558();
            }
            world.method_8486(user.method_23317(), user.method_23318(), user.method_23321(), MineCellsSounds.TENTACLE_CHARGE, user.method_5634(), 1.0f, 1.0f, false);
            UseTentacleWeaponC2SPacket packet = new UseTentacleWeaponC2SPacket(pos);
            packet.send();
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public boolean canCrit(class_1799 stack, class_1309 target, class_1309 attacker) {
        return attacker.method_5685().stream().anyMatch(it -> it.method_5864() == MineCellsEntities.TENTACLE_WEAPON);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        this.fillTooltip(tooltip, false, "item.minecells.tentacle.description", stack);
    }

    @Override
    public float getBaseAbilityDamage(class_1799 stack) {
        return 0.0f;
    }

    @Override
    public int getBaseAbilityCooldown(class_1799 stack) {
        return 30;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (!world.field_9236 || !selected) {
            return;
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7357().method_7904((class_1792)this)) {
            this.hitResult = null;
            return;
        }
        int maxDistance = MineCells.COMMON_CONFIG.baseTentacleMaxDistance;
        int minDistance = 3;
        class_243 targetPos = entity.method_33571().method_1019(entity.method_5828(0.5f).method_1021((double)maxDistance));
        class_3966 entityRaycast = class_1675.method_18075((class_1297)entity, (class_243)entity.method_33571(), (class_243)targetPos, (class_238)class_238.method_30048((class_243)entity.method_33571(), (double)(maxDistance * 2), (double)(maxDistance * 2), (double)(maxDistance * 2)), Objects::nonNull, (double)(maxDistance * maxDistance));
        if (entityRaycast != null && entityRaycast.method_17783() != class_239.class_240.field_1333 && entityRaycast.method_17784().method_1025(entity.method_33571()) >= (double)(minDistance * minDistance)) {
            this.hitResult = entityRaycast;
            return;
        }
        this.hitResult = world.method_17742(new class_3959(entity.method_33571(), targetPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        if (this.hitResult != null && class_2338.method_49638((class_2374)this.hitResult.method_17784()).method_19770((class_2374)entity.method_19538()) <= (double)(minDistance * minDistance)) {
            this.hitResult = null;
        }
    }
}

