/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.nonliving;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.MineCellsBlockTags;
import com.github.mim1q.minecells.entity.SewersTentacleEntity;
import com.github.mim1q.minecells.entity.damage.MineCellsDamageSource;
import com.github.mim1q.minecells.network.PacketIdentifiers;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5172;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class ElevatorEntity
extends class_1297 {
    private static final class_2940<Boolean> MOVING = class_2945.method_12791(ElevatorEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> GOING_UP = class_2945.method_12791(ElevatorEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ROTATED = class_2945.method_12791(ElevatorEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> VELOCITY_MODIFIER = class_2945.method_12791(ElevatorEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> MIN_Y = class_2945.method_12791(ElevatorEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_Y = class_2945.method_12791(ElevatorEntity.class, (class_2941)class_2943.field_13327);
    private boolean unbreakable = false;
    protected double serverY;
    protected int interpolationSteps = 0;
    protected int stoppedTicks = 0;
    protected boolean setup = false;
    boolean wasMoving = false;
    boolean poweredTop = true;
    boolean poweredBottom = true;
    float maxSpeed;
    float acceleration;
    float damage;
    protected ArrayList<class_1309> hitEntities;

    public ElevatorEntity(class_1299<ElevatorEntity> type, class_1937 world) {
        super(type, world);
        this.maxSpeed = MineCells.COMMON_CONFIG.elevator.speed;
        this.acceleration = MineCells.COMMON_CONFIG.elevator.acceleration;
        this.damage = MineCells.COMMON_CONFIG.elevator.damage;
        this.hitEntities = new ArrayList();
        this.field_23807 = true;
        this.field_5985 = true;
        this.field_5960 = true;
        this.serverY = this.method_23318();
    }

    public static ElevatorEntity spawn(class_1937 world, int x, int z, int minY, int maxY, boolean isRotated, boolean isGoingUp) {
        ElevatorEntity elevator = new ElevatorEntity(MineCellsEntities.ELEVATOR, world);
        elevator.method_5814((double)x + 0.5, isGoingUp ? (double)maxY : (double)minY, (double)z + 0.5);
        elevator.setMaxY(maxY);
        elevator.setMinY(minY);
        elevator.setRotated(isRotated);
        elevator.setGoingUp(isGoingUp);
        world.method_8649((class_1297)elevator);
        return elevator;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    protected void method_5693() {
        this.field_6011.method_12784(MOVING, (Object)false);
        this.field_6011.method_12784(GOING_UP, (Object)false);
        this.field_6011.method_12784(ROTATED, (Object)false);
        this.field_6011.method_12784(VELOCITY_MODIFIER, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(MIN_Y, (Object)((int)this.method_23318()));
        this.field_6011.method_12784(MAX_Y, (Object)((int)this.method_23318()));
    }

    public void method_5773() {
        super.method_5773();
        double nextY = this.method_23318() + this.method_18798().field_1351;
        if (!this.method_37908().method_8608()) {
            boolean isMoving;
            float modifiedAcceleration = this.isGoingUp() ? this.acceleration : -this.acceleration;
            this.setVelocityModifier(class_3532.method_15363((float)(modifiedAcceleration + this.getVelocityModifier()), (float)-1.0f, (float)1.0f));
            this.method_18800(0.0, this.maxSpeed * this.getVelocityModifier(), 0.0);
            this.field_6007 = true;
            this.field_6037 = true;
            boolean bl = isMoving = !(nextY < (double)this.getMinY()) && !(nextY > (double)this.getMaxY());
            if (this.isMoving()) {
                this.stoppedTicks = 0;
            } else {
                if (this.stoppedTicks == 1) {
                    this.method_5783(MineCellsSounds.ELEVATOR_STOP, 1.0f, 1.0f);
                }
                ++this.stoppedTicks;
            }
            if (!isMoving) {
                if (this.isGoingUp()) {
                    this.setVelocityModifier(Math.max(this.getVelocityModifier(), 0.0f));
                } else {
                    this.setVelocityModifier(Math.min(this.getVelocityModifier(), 0.0f));
                }
            }
            this.setMoving(isMoving);
            this.interpolationSteps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
            this.handlePassengers();
            this.handleRedstone();
        } else {
            if (this.wasMoving && !this.isMoving() && !this.isGoingUp()) {
                class_2338 pos = new class_2338(this.method_31477(), this.getMinY() - 1, this.method_31479());
                class_2680 state = this.method_5770().method_8320(pos);
                class_2388 particle = new class_2388(class_2398.field_11217, state);
                if (!state.method_26215() && nextY < (double)this.getMinY()) {
                    for (int i = 0; i < 20; ++i) {
                        double rx = this.field_5974.method_43058() - 0.5;
                        double rz = this.field_5974.method_43058() - 0.5;
                        class_243 vel = new class_243(rx, 0.1, rz).method_1029();
                        ParticleUtils.addParticle((class_638)this.method_37908(), (class_2394)particle, this.method_19538().method_1019(vel), vel.method_1021(10.0));
                        ParticleUtils.addParticle((class_638)this.method_37908(), (class_2394)class_2398.field_17430, this.method_19538().method_1019(vel), vel.method_1021(0.01));
                    }
                }
            }
            this.wasMoving = this.isMoving();
        }
        if (this.interpolationSteps > 0) {
            double d = this.method_23317();
            double e = this.method_23318() + (this.serverY - this.method_23318()) / (double)this.interpolationSteps;
            double f = this.method_23321();
            --this.interpolationSteps;
            this.method_5814(d, e, f);
        }
        double clampedY = class_3532.method_15350((double)(this.method_23318() + this.method_18798().field_1351), (double)this.getMinY(), (double)this.getMaxY());
        this.method_5814(this.method_23317(), clampedY, this.method_23321());
        if (this.isMoving()) {
            if (this.method_37908().method_8608()) {
                double z = this.isRotated() ? 1.0 : 0.0;
                double x = 1.0 - z;
                this.spawnMovementParticles(new class_243(-x, 0.0, -z));
                this.spawnMovementParticles(new class_243(x, 0.0, z));
            } else if (!this.isGoingUp()) {
                this.handleEntitiesBelow();
            }
        }
        if (this.shouldBeRemoved()) {
            this.method_5768();
        }
    }

    private boolean shouldBeRemoved() {
        class_2338 pos0 = this.method_24515().method_10067();
        class_2338 pos1 = this.method_24515().method_10078();
        if (this.isRotated()) {
            pos0 = this.method_24515().method_10072();
            pos1 = this.method_24515().method_10095();
        }
        class_2680 state0 = this.method_37908().method_8320(pos0);
        class_2680 state1 = this.method_37908().method_8320(pos1);
        if (state0.method_26204() instanceof class_5172 && state1.method_26204() instanceof class_5172) {
            return state0.method_11654((class_2769)class_5172.field_11459) != class_2350.class_2351.field_11052 && state1.method_11654((class_2769)class_5172.field_11459) != class_2350.class_2351.field_11052;
        }
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (!this.unbreakable && player.field_6266 != null && player.method_5998(player.field_6266).method_7909() instanceof class_1743) {
                this.method_5768();
            }
        }
        return super.method_5698(attacker);
    }

    public void method_5768() {
        if (!this.method_37908().method_8608()) {
            class_1799[] items;
            for (class_1799 itemStack : items = new class_1799[]{new class_1799((class_1935)class_2246.field_23985, this.field_5974.method_43048(3) + 2), new class_1799((class_1935)MineCellsBlocks.PUTRID_WOOD.planks, 1), new class_1799((class_1935)MineCellsItems.ELEVATOR_MECHANISM, this.field_5974.method_43048(3))}) {
                class_1542 entity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
                this.method_37908().method_8649((class_1297)entity);
            }
            this.method_5783(class_3417.field_15215, 1.0f, 1.0f);
            class_2540 buf = PacketByteBufs.create();
            buf.writeDouble(this.method_23317());
            buf.writeDouble(this.method_23318());
            buf.writeDouble(this.method_23321());
            for (class_3222 player : PlayerLookup.tracking((class_1297)this)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.ELEVATOR_DESTROYED, (class_2540)buf);
            }
            super.method_5768();
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.method_5814(x, this.method_23318(), z);
        this.serverY = y;
        this.interpolationSteps = interpolationSteps;
    }

    protected void spawnMovementParticles(class_243 offset) {
        for (int i = 0; i < 5; ++i) {
            double rx = (this.field_5974.method_43058() - 0.5) * 0.5;
            double rz = (this.field_5974.method_43058() - 0.5) * 0.5;
            ParticleUtils.addParticle((class_638)this.method_37908(), (class_2394)class_2398.field_29644, this.method_19538().method_1019(offset), new class_243(rx, this.isGoingUp() ? -1.0 : 1.0, rz));
        }
    }

    public void handlePassengers() {
        if (this.isMoving()) {
            this.addPassengers();
        } else if (this.stoppedTicks > 1) {
            this.method_5772();
            this.hitEntities.clear();
        }
    }

    public void addPassengers() {
        List entities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1009(0.0, 0.5, 0.0), this::canBePassenger);
        for (class_1309 e : entities) {
            if (e instanceof class_1314) {
                class_1314 pathAwareEntity = (class_1314)e;
                pathAwareEntity.method_5942().method_6340();
            }
            e.method_5804((class_1297)this);
        }
    }

    protected boolean canBePassenger(class_1309 entity) {
        return !this.hitEntities.contains(entity) && entity.method_23318() >= this.method_23318() && !entity.method_5715() && !(entity instanceof SewersTentacleEntity);
    }

    public void handleEntitiesBelow() {
        class_1309 e22;
        List entities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_989(0.0, -1.0, 0.0), e -> !this.hitEntities.contains(e));
        for (class_1309 e22 : entities) {
            if (this.hitEntities.contains(e22)) continue;
            e22.method_18799(e22.method_19538().method_1020(this.method_19538()).method_1029().method_18805(3.0, 0.0, 3.0).method_1031(0.0, 0.5, 0.0));
            e22.method_5643(MineCellsDamageSource.ELEVATOR.get(this.method_37908(), null), this.damage);
            this.hitEntities.add(e22);
        }
        if (!entities.isEmpty() && !this.method_37908().field_9236 && (e22 = this.method_31483()) instanceof class_3222) {
            class_3222 player = (class_3222)e22;
            if (this.method_37908().method_8503() != null) {
                class_161 advancement = this.method_37908().method_8503().method_3851().method_12896(MineCells.createId("elevator"));
                player.method_14236().method_12878(advancement, "entity_squashed");
            }
        }
    }

    public void handleRedstone() {
        boolean top = this.checkSignal(this.getMaxY());
        boolean bottom = this.checkSignal(this.getMinY());
        if (top && !this.poweredTop && !this.isGoingUp()) {
            this.startMoving(true, true);
        } else if (bottom & !this.poweredBottom && this.isGoingUp()) {
            this.startMoving(false, true);
        }
        this.poweredTop = top;
        this.poweredBottom = bottom;
    }

    protected boolean checkSignal(int y) {
        class_2382[] offsets = new class_2382[]{new class_2382(-2, 0, 0), new class_2382(0, 0, -2), new class_2382(0, 0, 2), new class_2382(2, 0, 0)};
        class_2338 pos = new class_2338(this.method_31477(), y, this.method_31479());
        for (class_2382 offset : offsets) {
            if (this.method_37908().method_49804(pos.method_10081(offset)) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean validateShaft(class_1937 world, int x, int z, int minY, int maxY, boolean rotated) {
        class_2382[] offsets = new class_2382[]{new class_2382(-1, 0, -1), new class_2382(-1, 0, 0), new class_2382(-1, 0, 1), new class_2382(0, 0, -1), new class_2382(0, 0, 0), new class_2382(0, 0, 1), new class_2382(1, 0, -1), new class_2382(1, 0, 0), new class_2382(1, 0, 1)};
        int chain0 = 1;
        int chain1 = 7;
        if (rotated) {
            chain0 = 3;
            chain1 = 5;
        }
        for (int i = 0; i < 9; ++i) {
            boolean chain = i == chain0 || i == chain1;
            for (int y = minY; y <= maxY + 1; ++y) {
                if (i == 4 && (y == minY || y == maxY)) continue;
                class_2338 pos = new class_2338(x, y, z);
                class_2338 offsetPos = pos.method_10081(offsets[i]);
                class_2680 state = world.method_8320(offsetPos);
                if (!(chain ? !state.method_26164(MineCellsBlockTags.ELEVATOR_CHAINS) || !state.method_28501().contains(class_5172.field_11459) || state.method_11654((class_2769)class_5172.field_11459) != class_2350.class_2351.field_11052 : state.method_26212((class_1922)world, offsetPos))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean startMoving(boolean isGoingUp, boolean fromRedstone) {
        if ((!this.isMoving() || fromRedstone) && ElevatorEntity.validateShaft(this.method_37908(), this.method_31477(), this.method_31479(), this.getMinY(), this.getMaxY(), this.isRotated())) {
            if (!this.method_37908().method_8608() && (this.stoppedTicks > 5 || fromRedstone)) {
                this.setGoingUp(isGoingUp);
                if (!this.isMoving() && this.stoppedTicks > 5) {
                    this.setVelocityModifier(0.0f);
                    this.method_5783(MineCellsSounds.ELEVATOR_START, 1.0f, 1.0f);
                }
                this.setMoving(true);
            }
            return true;
        }
        return false;
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        return this.method_5688(player, hand);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        boolean result = this.startMoving(!this.isGoingUp(), false);
        if (result && !this.method_37908().method_8608()) {
            this.addPassengers();
        }
        return result ? class_1269.field_5812 : class_1269.field_5814;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)MineCellsBlocks.ELEVATOR_ASSEMBLER.method_8389());
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        positionUpdater.accept(passenger, passenger.field_6014, this.method_23318() + 0.5, passenger.field_5969);
    }

    public class_243 method_24829(class_1309 passenger) {
        if (this.isMoving()) {
            return new class_243(passenger.field_6014, this.method_23318(), passenger.field_5969);
        }
        return new class_243(passenger.field_6014, this.method_23318() + 0.5, passenger.field_5969);
    }

    protected boolean method_5818(class_1297 passenger) {
        return true;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        if (movementType != class_1313.field_6308) {
            return;
        }
        super.method_5784(movementType, movement);
    }

    public boolean method_30948() {
        return !this.isMoving();
    }

    public boolean method_30949(class_1297 other) {
        return true;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean isMoving() {
        return (Boolean)this.field_6011.method_12789(MOVING);
    }

    public void setMoving(boolean moving) {
        this.field_6011.method_12778(MOVING, (Object)moving);
    }

    public boolean isGoingUp() {
        return (Boolean)this.field_6011.method_12789(GOING_UP);
    }

    public void setGoingUp(boolean goingUp) {
        this.field_6011.method_12778(GOING_UP, (Object)goingUp);
    }

    public boolean isRotated() {
        return (Boolean)this.field_6011.method_12789(ROTATED);
    }

    public void setRotated(boolean rotated) {
        this.field_6011.method_12778(ROTATED, (Object)rotated);
    }

    public float getVelocityModifier() {
        return ((Float)this.field_6011.method_12789(VELOCITY_MODIFIER)).floatValue();
    }

    public void setVelocityModifier(float velocityModifier) {
        this.field_6011.method_12778(VELOCITY_MODIFIER, (Object)Float.valueOf(velocityModifier));
    }

    public int getMaxY() {
        return (Integer)this.field_6011.method_12789(MAX_Y);
    }

    public void setMaxY(int maxY) {
        this.field_6011.method_12778(MAX_Y, (Object)maxY);
    }

    public int getMinY() {
        return (Integer)this.field_6011.method_12789(MIN_Y);
    }

    public void setMinY(int minY) {
        this.field_6011.method_12778(MIN_Y, (Object)minY);
    }

    protected void method_5749(class_2487 nbt) {
        this.setGoingUp(nbt.method_10577("up"));
        this.setMinY(nbt.method_10550("minY"));
        this.setMaxY(nbt.method_10550("maxY"));
        this.setRotated(nbt.method_10577("rotated"));
        this.setup = nbt.method_10577("setup");
        this.poweredTop = nbt.method_10577("poweredTop");
        this.poweredBottom = nbt.method_10577("poweredBottom");
        this.unbreakable = nbt.method_10577("unbreakable");
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10556("up", this.isGoingUp());
        nbt.method_10569("minY", this.getMinY());
        nbt.method_10569("maxY", this.getMaxY());
        nbt.method_10556("rotated", this.isRotated());
        nbt.method_10556("setup", this.setup);
        nbt.method_10556("poweredTop", this.poweredTop);
        nbt.method_10556("poweredBottom", this.poweredBottom);
        nbt.method_10556("unbreakable", this.unbreakable);
    }
}

