/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.dimension;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.accessor.LivingEntityAccessor;
import com.github.mim1q.minecells.effect.MineCellsEffectFlags;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.TeleportUtils;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public enum MineCellsDimension {
    OVERWORLD(new class_2960("overworld"), 0, 0, 0, 0.0),
    PRISONERS_QUARTERS(MineCells.createId("prison"), 2, 43, 3, 1024.0, -90.0f),
    INSUFFERABLE_CRYPT(MineCells.createId("insufferable_crypt"), 6, 41, 2, 1024.0, 90.0f),
    PROMENADE_OF_THE_CONDEMNED(MineCells.createId("promenade"), 6, -5, 6, 1024.0),
    RAMPARTS(MineCells.createId("ramparts"), -54, 212, -265, 384.0, 180.0f),
    BLACK_BRIDGE(MineCells.createId("black_bridge"), 32, 70, 11, 384.0);

    private static final Set<MineCellsDimension> DIMENSIONS_WITH_SURFACE;
    public final class_5321<class_1937> key;
    private final class_2960 id;
    public final String translationKey;
    public final class_2382 spawnOffset;
    public final double borderSize;
    public final float yaw;

    private MineCellsDimension(class_2960 id, int offsetX, int offsetY, int offsetZ, double borderSize, float yaw) {
        this.key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
        this.id = id;
        this.translationKey = id.method_42093("dimension");
        this.spawnOffset = new class_2382(offsetX, offsetY, offsetZ);
        this.borderSize = borderSize;
        this.yaw = yaw;
    }

    private MineCellsDimension(class_2960 id, int offsetX, int offsetY, int offsetZ, double borderSize) {
        this(id, offsetX, offsetY, offsetZ, borderSize, 0.0f);
    }

    public class_243 getTeleportPosition(class_2338 pos, class_3218 world) {
        class_3218 destination = this.getWorld(world);
        class_2338 runCenter = new class_2338(MathUtils.getClosestMultiplePosition((class_2382)pos, 1024));
        class_2338 tpPos = runCenter.method_10069(this.spawnOffset.method_10263(), this.spawnOffset.method_10264(), this.spawnOffset.method_10260());
        if (DIMENSIONS_WITH_SURFACE.contains((Object)this)) {
            int y = destination.method_22350(tpPos).method_12005(class_2902.class_2903.field_13203, tpPos.method_10263(), tpPos.method_10260());
            return class_243.method_24953((class_2382)tpPos).method_1031(0.0, (double)y, 0.0);
        }
        return class_243.method_24953((class_2382)tpPos);
    }

    public void teleportPlayer(class_3222 player, class_3218 world, @Nullable class_2338 posOverride) {
        class_3218 destination = this.getWorld(world);
        class_243 teleportPos = this == OVERWORLD ? (player.method_26281() == MineCellsDimension.OVERWORLD.key && player.method_26280() != null ? class_243.method_24953((class_2382)player.method_26280()) : class_243.method_24953((class_2382)world.method_43126())) : this.getTeleportPosition(posOverride == null ? player.method_24515() : posOverride, world);
        TeleportUtils.teleportToDimension((class_1297)player, destination, teleportPos, this.yaw);
    }

    public class_3218 getWorld(class_3218 world) {
        return world.method_8503().method_3847(this.key);
    }

    public static MineCellsDimension of(class_5321<class_1937> key) {
        for (MineCellsDimension dimension : MineCellsDimension.values()) {
            if (!dimension.key.equals(key)) continue;
            return dimension;
        }
        return null;
    }

    public static MineCellsDimension of(class_1937 world) {
        return MineCellsDimension.of((class_5321<class_1937>)world.method_27983());
    }

    public static class_1937 getWorld(class_1937 world, class_5321<class_1937> key) {
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return null;
        }
        return server.method_3847(key);
    }

    public static boolean isMineCellsDimension(class_1937 world) {
        return world != null && world.method_27983().method_29177().method_12836().equals("minecells");
    }

    public static String getTranslationKey(class_5321<class_1937> dimension) {
        class_2960 id = dimension.method_29177();
        return "dimension." + id.method_12836() + "." + id.method_12832();
    }

    public static String getTranslationKey(String key) {
        class_2960 id = new class_2960(key);
        return "dimension." + id.method_12836() + "." + id.method_12832();
    }

    public static MineCellsDimension of(class_2960 id) {
        return Arrays.stream(MineCellsDimension.values()).filter(value -> value.id.equals((Object)id)).findFirst().orElse(null);
    }

    public static Double getFallResetHeight(class_1937 world) {
        if (!MineCellsDimension.isMineCellsDimension(world)) {
            return null;
        }
        return switch (MineCellsDimension.of(world)) {
            case RAMPARTS -> 180.0;
            default -> null;
        };
    }

    public int getDimensionLevel() {
        return switch (this) {
            case PROMENADE_OF_THE_CONDEMNED -> 1;
            case RAMPARTS -> 2;
            default -> 0;
        };
    }

    public class_5195 getMusic() {
        return switch (this) {
            case PRISONERS_QUARTERS -> MineCellsSounds.PRISONERS_QUARTERS;
            case PROMENADE_OF_THE_CONDEMNED -> MineCellsSounds.PROMENADE;
            case RAMPARTS -> MineCellsSounds.RAMPARTS;
            case INSUFFERABLE_CRYPT -> MineCellsSounds.INSUFFERABLE_CRYPT;
            default -> null;
        };
    }

    public boolean canMusicStart(class_746 player) {
        return switch (this) {
            case INSUFFERABLE_CRYPT -> {
                if (player != null && ((LivingEntityAccessor)player).getMineCellsFlag(MineCellsEffectFlags.DISARMED)) {
                    yield true;
                }
                yield false;
            }
            case BLACK_BRIDGE -> {
                if (player != null && class_310.method_1551().field_1705.method_1740() != null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    static {
        DIMENSIONS_WITH_SURFACE = Set.of(PROMENADE_OF_THE_CONDEMNED);
    }
}

