/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.compat.emi;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.compat.emi.MineCellsEmiPlugin;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class EmiCellCrafterRecipeDisplay
implements EmiRecipe {
    private static final class_2960 ARROW_TEXTURE = MineCells.createId("textures/gui/cell_crafter/emi_arrow.png");
    private final CellForgeRecipe recipe;

    public EmiCellCrafterRecipeDisplay(CellForgeRecipe recipe) {
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return MineCellsEmiPlugin.CELL_CRAFTER_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return this.recipe.method_8117().stream().map(EmiIngredient::of).toList();
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((class_1799)this.recipe.method_8110(null)));
    }

    public int getDisplayWidth() {
        return this.getInputs().size() * 20;
    }

    public int getDisplayHeight() {
        return 58;
    }

    public void addWidgets(WidgetHolder widgets) {
        int widgetX = this.getDisplayWidth() / 2 - this.getInputs().size() * 10 + 2;
        for (EmiIngredient input : this.getInputs()) {
            widgets.addSlot(input, widgetX, 0);
            widgetX += 20;
        }
        boolean hasAdvancement = this.recipe.requiredAdvancement().isPresent();
        TextureWidget arrow = widgets.addTexture(ARROW_TEXTURE, this.getDisplayWidth() / 2 - 8, 22, hasAdvancement ? 24 : 16, 16, 0, 0, hasAdvancement ? 24 : 16, 16, 32, 32);
        if (hasAdvancement) {
            arrow.tooltip((x, y) -> {
                String advancementKey = class_156.method_646((String)"advancements", (class_2960)this.recipe.requiredAdvancement().orElseThrow()) + ".description";
                return List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)"block.minecells.cell_crafter.requirement").method_27692(class_124.field_1061).method_30937()), class_5684.method_32662((class_5481)class_2561.method_43471((String)advancementKey).method_27692(class_124.field_1080).method_30937()));
            });
        }
        widgets.addSlot((EmiIngredient)this.getOutputs().get(0), this.getDisplayWidth() / 2 - 8, 40);
    }
}

