/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.MineCellsClient;
import com.github.mim1q.minecells.client.render.MineCellsEntityRenderer;
import com.github.mim1q.minecells.client.render.feature.GlowFeatureRenderer;
import com.github.mim1q.minecells.client.render.model.ProtectorEntityModel;
import com.github.mim1q.minecells.entity.ProtectorEntity;
import com.github.mim1q.minecells.registry.MineCellsRenderers;
import com.github.mim1q.minecells.util.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ProtectorEntityRenderer
extends MineCellsEntityRenderer<ProtectorEntity, ProtectorEntityModel> {
    private static final class_2960 TEXTURE = MineCells.createId("textures/entity/protector/protector.png");
    private static final class_2960 GLOW_TEXTURE = MineCells.createId("textures/entity/protector/protector_glow.png");
    private static final class_2960 CONNECTION_TEXTURE = MineCells.createId("textures/misc/electric_arch.png");
    private static final class_1921 CONNECTION_LAYER = class_1921.method_23576((class_2960)CONNECTION_TEXTURE);

    public ProtectorEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx, new ProtectorEntityModel(ctx.method_32167(MineCellsRenderers.PROTECTOR_LAYER)), 0.35f);
        if (MineCellsClient.CLIENT_CONFIG.rendering.protectorGlow) {
            this.method_4046(new GlowFeatureRenderer(this, GLOW_TEXTURE));
        }
    }

    @Override
    public void render(ProtectorEntity mobEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        if (mobEntity.isActive()) {
            for (class_1297 e : mobEntity.trackedEntities) {
                this.renderConnection(vertexConsumerProvider.getBuffer(CONNECTION_LAYER), matrix4f, matrix3f, new class_243(0.0, 1.25, 0.0), e.method_19538().method_1020(mobEntity.method_19538()).method_1031(0.0, (double)e.method_17682() * 0.5, 0.0), e.field_6012 % 8, i);
            }
        }
    }

    protected void renderConnection(class_4588 vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, class_243 p0, class_243 p1, int frame, int light) {
        int[] indices;
        float x0 = (float)p0.field_1352;
        float y0 = (float)p0.field_1351;
        float z0 = (float)p0.field_1350;
        float x1 = (float)p1.field_1352;
        float y1 = (float)p1.field_1351;
        float z1 = (float)p1.field_1350;
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        dx = dx == 0.0f ? 0.001f : dx;
        float dHorizontal = class_3532.method_15355((float)(dx * dx + dz * dz));
        float length = class_3532.method_15355((float)(dHorizontal * dHorizontal + dy * dy));
        float offset = 0.5f;
        float yOffset = offset * (dHorizontal / length);
        float xOffset = offset * (dy / length) * (dx / dHorizontal);
        float zOffset = offset * (dy / length) * (dz / dHorizontal);
        float v0 = (float)frame * 0.125f;
        float v1 = v0 + 0.125f;
        RenderUtils.VertexCoordinates[] vertices = new RenderUtils.VertexCoordinates[]{new RenderUtils.VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new RenderUtils.VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new RenderUtils.VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new RenderUtils.VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
        for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
            RenderUtils.produceVertex(vertexConsumer, positionMatrix, normalMatrix, 240, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v, 255);
        }
    }

    public class_2960 getTexture(ProtectorEntity entity) {
        return TEXTURE;
    }
}

