/*
 * Decompiled with CFR 0.152.
 */
package net.talestudios.lsmorecraftingtables.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryObject;
import net.talestudios.lsmorecraftingtables.blocks.BlockIds;
import net.talestudios.lsmorecraftingtables.blocks.CraftingBlock;
import net.talestudios.lsmorecraftingtables.blocks.Registration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ModBlocks {
    public static final List<RegistryObject<Block>> CRAFTING_TABLES = ModBlocks.createCraftingTables();

    @NotNull
    private static List<RegistryObject<Block>> createCraftingTables() {
        ArrayList<RegistryObject<Block>> craftingTables = new ArrayList<RegistryObject<Block>>();
        for (String tableName : BlockIds.CRAFTING_TABLES) {
            craftingTables.add(ModBlocks.register(tableName + "_crafting_table"));
        }
        return craftingTables;
    }

    public static RegistryObject<Block> register(String name) {
        return Registration.BLOCKS.register(name, ModBlocks::createCraftingBlock);
    }

    @Contract(value=" -> new")
    @NotNull
    private static CraftingBlock createCraftingBlock() {
        return new CraftingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50091_).m_60978_(2.0f));
    }

    public static void registerBlockItems() {
        for (RegistryObject<Block> blockObject : CRAFTING_TABLES) {
            Registration.ITEMS.register(blockObject.getId().m_135815_(), () -> new BlockItem((Block)blockObject.get(), new Item.Properties()));
        }
    }

    public static void register() {
    }
}

