/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.LicowitchTowerStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class LicowitchTowerStructure
extends Structure {
    public static final Codec<LicowitchTowerStructure> CODEC = LicowitchTowerStructure.m_226607_(settings -> new LicowitchTowerStructure((Structure.StructureSettings)settings));
    private static final ResourceLocation TOWER_NBT = new ResourceLocation("alexscaves", "licowitch_tower");
    private static final int Y = 0;

    public LicowitchTowerStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int i = context.f_226628_().m_151382_(9);
        int j = context.f_226628_().m_151391_(9);
        Iterator<Holder<Biome>> iterator = ACMath.getBiomesWithinAtY(context.f_226623_(), i, -30, j, 20, context.f_226624_().m_224579_()).iterator();
        if (iterator.hasNext()) {
            Holder<Biome> holder = iterator.next();
            return Optional.empty();
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), 0, context.f_226628_().m_45605_());
        return this.atYCaveBiomePoint(context, piecesBuilder -> piecesBuilder.m_142679_((StructurePiece)new LicowitchTowerStructurePiece(context.f_226625_(), TOWER_NBT, blockpos, rotation)));
    }

    protected Optional<Structure.GenerationStub> atYCaveBiomePoint(Structure.GenerationContext context, Consumer<StructurePiecesBuilder> builderConsumer) {
        ChunkPos chunkpos = context.f_226628_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, 0, j), builderConsumer));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.LICOWITCH_TOWER.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

