/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.GingerbreadHousePiece;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.GingerbreadRoadPiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GingerbreadTownStructure
extends Structure {
    public static final Codec<GingerbreadTownStructure> CODEC = GingerbreadTownStructure.m_226607_(settings -> new GingerbreadTownStructure((Structure.StructureSettings)settings));
    private static final int Y = 0;

    public GingerbreadTownStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int i = context.f_226628_().m_151382_(9);
        int j = context.f_226628_().m_151391_(9);
        Iterator<Holder<Biome>> iterator = ACMath.getBiomesWithinAtY(context.f_226623_(), i, -30, j, 20, context.f_226624_().m_224579_()).iterator();
        if (iterator.hasNext()) {
            Holder<Biome> holder = iterator.next();
            return Optional.empty();
        }
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), 0, context.f_226628_().m_45605_());
        return this.atYCaveBiomePoint(context, piecesBuilder -> this.buildTown(context, blockpos, (StructurePiecesBuilder)piecesBuilder));
    }

    private void buildTown(Structure.GenerationContext context, BlockPos blockpos, StructurePiecesBuilder piecesBuilder) {
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        StructureTemplate centerTemplate = context.f_226625_().m_230359_(GingerbreadHousePiece.TOWN_CENTER_TEMPLATE);
        Vec3i centerSize = centerTemplate.m_163808_(rotation);
        BlockPos townCenterPos1 = blockpos.m_7918_(-centerSize.m_123341_() / 2, 0, -centerSize.m_123343_() / 2);
        BlockPos townCenterPos2 = centerTemplate.m_74583_(townCenterPos1, Mirror.NONE, rotation);
        GingerbreadRoadPiece roadPiece = new GingerbreadRoadPiece(context.f_226625_(), blockpos, 30, 5, rotation.m_55954_(Direction.NORTH));
        piecesBuilder.m_142679_((StructurePiece)roadPiece);
        GingerbreadHousePiece townCenterPiece = new GingerbreadHousePiece(context.f_226625_(), GingerbreadHousePiece.TOWN_CENTER_TEMPLATE, townCenterPos2, rotation);
        roadPiece.pendingChildren.add((StructurePiece)townCenterPiece);
        piecesBuilder.m_142679_((StructurePiece)townCenterPiece);
        roadPiece.m_214092_(roadPiece, (StructurePieceAccessor)piecesBuilder, (RandomSource)context.f_226626_());
        List<StructurePiece> list = roadPiece.pendingChildren;
        while (!list.isEmpty()) {
            int i = context.f_226626_().m_188503_(list.size());
            StructurePiece structurepiece = list.remove(i);
            structurepiece.m_214092_((StructurePiece)roadPiece, (StructurePieceAccessor)piecesBuilder, (RandomSource)context.f_226626_());
        }
    }

    protected Optional<Structure.GenerationStub> atYCaveBiomePoint(Structure.GenerationContext context, Consumer<StructurePiecesBuilder> builderConsumer) {
        ChunkPos chunkpos = context.f_226628_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, 0, j), builderConsumer));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.GINGERBREAD_TOWN.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

