/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.DonutArchStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class DonutArchStructure
extends Structure {
    public static final Codec<DonutArchStructure> CODEC = DonutArchStructure.m_226607_(settings -> new DonutArchStructure((Structure.StructureSettings)settings));
    public static final int DONUT_SECTION_WIDTH = 16;

    protected DonutArchStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return this.atYCaveBiomePoint(context, Heightmap.Types.OCEAN_FLOOR_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    protected Optional<Structure.GenerationStub> atYCaveBiomePoint(Structure.GenerationContext context, Heightmap.Types heightMap, Consumer<StructurePiecesBuilder> builderConsumer) {
        ChunkPos chunkpos = context.f_226628_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        int k = -30;
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, k, j), builderConsumer));
    }

    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int i = context.f_226628_().m_45604_();
        int j = context.f_226628_().m_45605_();
        int k = context.f_226622_().m_6337_();
        BlockPos xzCoords = new BlockPos(i, -30, j);
        int biomeUp = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.UP, xzCoords, 25);
        int biomeDown = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.DOWN, xzCoords, 16);
        BlockPos center = xzCoords.m_6625_(biomeDown).m_6630_(5 + worldgenrandom.m_188503_(Math.max(biomeUp, 10)));
        Direction donutFacing = (Direction)Util.m_214670_((Object[])ACMath.HORIZONTAL_DIRECTIONS, (RandomSource)worldgenrandom);
        int donutRadius = 32;
        int biomeLeft = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), donutFacing.m_122427_(), center, donutRadius);
        int biomeRight = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), donutFacing.m_122428_(), center, donutRadius);
        int widthChunks = (int)Math.ceil(biomeRight + biomeLeft) / 2 / 16;
        int frostingType = worldgenrandom.m_188503_(3);
        for (int chunkXZ = -widthChunks; chunkXZ <= widthChunks; ++chunkXZ) {
            for (int chunkY = -widthChunks; chunkY <= widthChunks; ++chunkY) {
                BlockPos at = center.m_5484_(donutFacing, chunkXZ * 16).m_6630_(chunkY * 16);
                builder.m_142679_((StructurePiece)new DonutArchStructurePiece(center, at, donutFacing, widthChunks * 16, frostingType));
            }
        }
    }

    private static Holder<Biome> getBiomeHolder(BiomeSource biomeSource, RandomState randomState, BlockPos pos) {
        return biomeSource.m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), randomState.m_224579_());
    }

    protected int biomeContinuesInDirectionFor(BiomeSource biomeSource, RandomState randomState, Direction direction, BlockPos start, int cutoff) {
        int i;
        block0: {
            i = 0;
            if (i >= cutoff) break block0;
            BlockPos check = start.m_5484_(direction, i);
            Holder<Biome> biomeHolder = DonutArchStructure.getBiomeHolder(biomeSource, randomState, check);
        }
        return Math.min(i, cutoff);
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.DONUT_ARCH.get();
    }
}

