/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.AlwaysCombinableOnAnvil;
import com.github.alexmodguy.alexscaves.server.item.UpdatesStackTags;
import com.github.alexmodguy.alexscaves.server.message.UpdateEffectVisualityEntityMessage;
import com.github.alexmodguy.alexscaves.server.message.UpdateItemTagMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class RaygunItem
extends Item
implements UpdatesStackTags,
AlwaysCombinableOnAnvil {
    private static final int MAX_CHARGE = 1000;
    public static final Predicate<ItemStack> AMMO = stack -> stack.m_41720_() == ((Block)ACBlockRegistry.URANIUM_ROD.get()).m_5456_();

    public RaygunItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public static boolean hasCharge(ItemStack stack) {
        return RaygunItem.getCharge(stack) < 1000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (RaygunItem.hasCharge(itemstack)) {
            player.m_6672_(interactionHand);
            player.m_216990_((SoundEvent)ACSoundRegistry.RAYGUN_START.get());
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        ItemStack ammo = this.findAmmo(player);
        boolean flag = player.m_7500_();
        if (!ammo.m_41619_()) {
            ammo.m_41774_(1);
            flag = true;
        }
        if (flag) {
            RaygunItem.setCharge(itemstack, 0);
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.RAYGUN_RELOAD.get(), player.m_5720_(), 1.0f, 1.0f);
        } else {
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ACSoundRegistry.RAYGUN_EMPTY.get(), player.m_5720_(), 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private ItemStack findAmmo(Player entity) {
        if (entity.m_7500_()) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < entity.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack1 = entity.m_150109_().m_8020_(i);
            if (!AMMO.test(itemstack1)) continue;
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        boolean using = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21211_().equals(stack);
        int useTime = RaygunItem.getUseTime(stack);
        if (!level.f_46443_) {
            int charge;
            if (stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SOLAR.get()) > 0 && !using && (charge = RaygunItem.getCharge(stack)) > 0 && level.f_46441_.m_188501_() < 0.02f) {
                BlockPos playerPos = entity.m_20183_().m_7494_();
                float timeOfDay = level.m_46942_(1.0f);
                if (level.m_45527_(playerPos) && level.m_46461_() && !level.m_6042_().m_63967_() && ((double)timeOfDay < 0.259 || (double)timeOfDay > 0.74)) {
                    RaygunItem.setCharge(stack, charge - 1);
                    RaygunItem.setUseTime(stack, 0);
                }
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("PrevUseTime") != tag.m_128451_("UseTime")) {
                tag.m_128405_("PrevUseTime", RaygunItem.getUseTime(stack));
            }
            if (using && (float)useTime < 5.0f) {
                RaygunItem.setUseTime(stack, useTime + 1);
            }
            if (!using && (float)useTime > 0.0f) {
                RaygunItem.setUseTime(stack, useTime - 1);
            }
        }
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int timeUsing) {
        ParticleOptions particleOptions;
        boolean gamma;
        Vec3 vec31;
        int realStart;
        int i = this.m_8105_(stack) - timeUsing;
        float time = i < (realStart = 15) ? (float)i / (float)realStart : 1.0f;
        float maxDist = 25.0f * time;
        boolean xRay = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.X_RAY.get()) > 0;
        HitResult realHitResult = ProjectileUtil.m_278180_((Entity)living, Entity::m_271807_, (double)maxDist);
        HitResult blockOnlyHitResult = living.m_19907_((double)maxDist, 0.0f, false);
        Vec3 xRayVec = living.m_20252_(0.0f).m_82490_((double)maxDist).m_82549_(living.m_146892_());
        Vec3 vec3 = xRay ? xRayVec : blockOnlyHitResult.m_82450_();
        Vec3 vec32 = vec31 = xRay ? xRayVec : blockOnlyHitResult.m_82450_();
        if (!RaygunItem.hasCharge(stack)) {
            if (level.f_46443_) {
                AlexsCaves.sendMSGToServer(new UpdateItemTagMessage(living.m_19879_(), stack));
            }
            living.m_5810_();
            level.m_6263_((Player)null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)ACSoundRegistry.RAYGUN_EMPTY.get(), living.m_5720_(), 1.0f, 1.0f);
            return;
        }
        if (level.f_46443_) {
            RaygunItem.setRayPosition(stack, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            AlexsCaves.PROXY.playWorldSound(living, (byte)8);
            int efficency = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.ENERGY_EFFICIENCY.get());
            int divis = 2 + (int)Math.floor((float)efficency * 1.5f);
            if (!(!(time >= 1.0f) || i % divis != 0 || living instanceof Player && ((Player)living).m_7500_())) {
                int charge = RaygunItem.getCharge(stack);
                RaygunItem.setCharge(stack, Math.min(charge + 1, 1000));
            }
        }
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        float deltaZ = 0.0f;
        boolean bl = gamma = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.GAMMA_RAY.get()) > 0;
        if (level.f_46441_.m_188499_() && time >= 1.0f) {
            particleOptions = gamma ? (ParticleOptions)ACParticleRegistry.BLUE_RAYGUN_EXPLOSION.get() : (ParticleOptions)ACParticleRegistry.RAYGUN_EXPLOSION.get();
        } else {
            particleOptions = gamma ? (ParticleOptions)ACParticleRegistry.BLUE_HAZMAT_BREATHE.get() : (ParticleOptions)ACParticleRegistry.HAZMAT_BREATHE.get();
            deltaX = (level.f_46441_.m_188501_() - 0.5f) * 0.2f;
            deltaY = (level.f_46441_.m_188501_() - 0.5f) * 0.2f;
            deltaZ = (level.f_46441_.m_188501_() - 0.5f) * 0.2f;
        }
        level.m_7106_(particleOptions, vec3.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.45f), vec3.f_82480_ + (double)0.2f, vec3.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.45f), (double)deltaX, (double)deltaY, (double)deltaZ);
        Direction blastHitDirection = null;
        Vec3 blastHitPos = null;
        if (xRay) {
            AABB maxAABB = living.m_20191_().m_82400_((double)maxDist);
            Vec3 startClip = living.m_146892_();
            for (float fakeRayTraceProgress = 1.0f; fakeRayTraceProgress < maxDist; fakeRayTraceProgress += 1.0f) {
                Vec3 endClip;
                EntityHitResult attemptedHitResult = ProjectileUtil.m_37304_((Level)level, (Entity)living, (Vec3)(startClip = startClip.m_82549_(living.m_20252_(1.0f))), (Vec3)(endClip = startClip.m_82549_(living.m_20252_(1.0f))), (AABB)maxAABB, Entity::m_271807_);
                if (attemptedHitResult == null) continue;
                realHitResult = attemptedHitResult;
                break;
            }
        } else if (realHitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)realHitResult;
            BlockPos pos = blockHitResult.m_82425_();
            BlockState state = level.m_8055_(pos);
            blastHitDirection = blockHitResult.m_82434_();
            if (!state.m_60795_() && state.m_60783_((BlockGetter)level, pos, blastHitDirection)) {
                blastHitPos = realHitResult.m_82450_();
            }
        }
        if (realHitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)realHitResult;
            blastHitPos = entityHitResult.m_82443_().m_20182_();
            blastHitDirection = Direction.UP;
            vec31 = blastHitPos;
        }
        if (blastHitPos != null && i % 2 == 0) {
            float offset = 0.05f + level.f_46441_.m_188501_() * 0.09f;
            Vec3 particleVec = blastHitPos.m_82520_((double)(offset * (float)blastHitDirection.m_122429_()), (double)(offset * (float)blastHitDirection.m_122430_()), (double)(offset * (float)blastHitDirection.m_122431_()));
            level.m_7106_((ParticleOptions)ACParticleRegistry.RAYGUN_BLAST.get(), particleVec.f_82479_, particleVec.f_82480_, particleVec.f_82481_, (double)blastHitDirection.m_122411_(), 0.0, 0.0);
        }
        if (!level.f_46443_ && (i - realStart) % 3 == 0) {
            AABB hitBox = new AABB(vec31.m_82520_(-1.0, -1.0, -1.0), vec31.m_82520_(1.0, 1.0, 1.0));
            int radiationLevel = gamma ? 4 : 0;
            for (Entity entity : level.m_6249_((Entity)living, hitBox, Entity::m_271807_)) {
                LivingEntity livingEntity;
                boolean flag;
                if (entity.m_7306_((Entity)living) || entity.m_7307_((Entity)living) || living.m_7307_(entity) || living.m_20365_(entity) || !(flag = entity.m_6469_(ACDamageTypes.causeRaygunDamage(level.m_9598_(), (Entity)living), gamma ? 2.0f : 1.5f)) || !(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_6095_().m_204039_(ACTagRegistry.RESISTS_RADIATION) || !livingEntity.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 800, radiationLevel))) continue;
                AlexsCaves.sendMSGToAll(new UpdateEffectVisualityEntityMessage(entity.m_19879_(), living.m_19879_(), gamma ? 4 : 0, 800));
            }
        }
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrevUseTime", RaygunItem.getUseTime(stack));
        tag.m_128405_("UseTime", useTime);
    }

    public static void setRayPosition(ItemStack stack, double x, double y, double z) {
        CompoundTag tag = stack.m_41784_();
        Vec3 prev = RaygunItem.getRayPosition(stack);
        tag.m_128347_("PrevRayX", prev.f_82479_);
        tag.m_128347_("PrevRayY", prev.f_82480_);
        tag.m_128347_("PrevRayZ", prev.f_82481_);
        tag.m_128347_("RayX", x);
        tag.m_128347_("RayY", y);
        tag.m_128347_("RayZ", z);
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("UseTime") : 0;
    }

    public static int getCharge(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("ChargeUsed") : 0;
    }

    public static void setCharge(ItemStack stack, int charge) {
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128405_("ChargeUsed", charge);
    }

    public static Vec3 getRayPosition(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_("RayX")) {
            return new Vec3(compoundtag.m_128459_("RayX"), compoundtag.m_128459_("RayY"), compoundtag.m_128459_("RayZ"));
        }
        return Vec3.f_82478_;
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevUseTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("UseTime") : 0.0f;
        return prev + f * (current - prev);
    }

    @Nullable
    public static Vec3 getLerpedRayPosition(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            double prevX = (float)compoundtag.m_128459_("PrevRayX");
            double x = (float)compoundtag.m_128459_("RayX");
            double prevY = (float)compoundtag.m_128459_("PrevRayY");
            double y = (float)compoundtag.m_128459_("RayY");
            double prevZ = (float)compoundtag.m_128459_("PrevRayZ");
            double z = (float)compoundtag.m_128459_("RayZ");
            return new Vec3(prevX + (double)f * (x - prevX), prevY + (double)f * (y - prevY), prevZ + (double)f * (z - prevZ));
        }
        return null;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity player, int useTimeLeft) {
        super.m_5551_(stack, level, player, useTimeLeft);
        if (level.f_46443_) {
            AlexsCaves.sendMSGToServer(new UpdateItemTagMessage(player.m_19879_(), stack));
        }
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)player);
    }

    public boolean m_142522_(ItemStack stack) {
        return RaygunItem.getCharge(stack) != 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)RaygunItem.getCharge(stack) * 13.0f / 1000.0f);
    }

    public int m_142159_(ItemStack stack) {
        float pulseRate = (float)RaygunItem.getCharge(stack) / 1000.0f * 2.0f;
        float f = (float)AlexsCaves.PROXY.getPlayerTime() + AlexsCaves.PROXY.getPartialTicks();
        float f1 = 0.5f * (float)(1.0 + Math.sin(f * pulseRate));
        return Mth.m_14169_((float)0.3f, (float)(f1 * 0.6f + 0.2f), (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (RaygunItem.getCharge(stack) != 0) {
            String chargeLeft = "" + (1000 - RaygunItem.getCharge(stack));
            tooltip.add((Component)Component.m_237110_((String)"item.alexscaves.raygun.charge", (Object[])new Object[]{chargeLeft, 1000}).m_130940_(ChatFormatting.GREEN));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ACItemRegistry.RAYGUN.get()) || !newStack.m_150930_((Item)ACItemRegistry.RAYGUN.get());
    }
}

