/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.GummyBearEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.world.entity.HumanoidArm;

public class GummyBearModel
extends AdvancedEntityModel<GummyBearEntity>
implements ArmedModel {
    private final AdvancedModelBox main;
    private final AdvancedModelBox body;
    private final AdvancedModelBox head;
    private final AdvancedModelBox nose;
    private final AdvancedModelBox left_Ear;
    private final AdvancedModelBox right_Ear;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox left_Arm;
    private final AdvancedModelBox right_Arm;
    private final AdvancedModelBox right_Leg;
    private final AdvancedModelBox left_Leg;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;
    public boolean ignoreColor;
    private final ModelAnimator animator;

    public GummyBearModel(float scale) {
        this.texWidth = 128;
        this.texHeight = 128;
        this.main = new AdvancedModelBox((AdvancedEntityModel)this);
        this.main.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -13.0f, 0.5f);
        this.main.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(0, 0).addBox(-8.0f, -7.0f, -10.5f, 16.0f, 14.0f, 21.0f, scale + 0.01f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, 1.5f, -10.0f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 35).addBox(-6.0f, -4.5f, -7.5f, 12.0f, 9.0f, 7.0f, scale, false);
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this);
        this.nose.setRotationPoint(0.0f, 1.5f, -7.5f);
        this.head.addChild((BasicModelPart)this.nose);
        this.nose.setTextureOffset(0, 9).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 5.0f, 3.0f, scale, false);
        this.left_Ear = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Ear.setRotationPoint(3.5f, -4.49f, -4.5f);
        this.head.addChild((BasicModelPart)this.left_Ear);
        this.left_Ear.setTextureOffset(34, 47).addBox(-2.5f, -2.0f, -2.0f, 5.0f, 2.0f, 4.0f, scale, false);
        this.right_Ear = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Ear.setRotationPoint(-3.5f, -4.49f, -4.5f);
        this.head.addChild((BasicModelPart)this.right_Ear);
        this.right_Ear.setTextureOffset(34, 47).addBox(-2.5f, -2.0f, -2.0f, 5.0f, 2.0f, 4.0f, scale, true);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, 2.0f, 10.0f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(0, 0).addBox(-3.0f, -3.0f, 0.5f, 6.0f, 6.0f, 3.0f, scale, false);
        this.left_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Arm.setRotationPoint(5.0f, 6.5f, -7.5f);
        this.body.addChild((BasicModelPart)this.left_Arm);
        this.left_Arm.setTextureOffset(38, 35).addBox(-3.0f, 0.5f, -3.0f, 6.0f, 6.0f, 6.0f, scale, false);
        this.right_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Arm.setRotationPoint(-5.0f, 6.5f, -7.5f);
        this.body.addChild((BasicModelPart)this.right_Arm);
        this.right_Arm.setTextureOffset(38, 35).addBox(-3.0f, 0.5f, -3.0f, 6.0f, 6.0f, 6.0f, scale, true);
        this.right_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Leg.setRotationPoint(-5.0f, 6.5f, 7.5f);
        this.body.addChild((BasicModelPart)this.right_Leg);
        this.right_Leg.setTextureOffset(38, 35).addBox(-3.0f, 0.5f, -3.0f, 6.0f, 6.0f, 6.0f, scale, true);
        this.left_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Leg.setRotationPoint(5.0f, 6.5f, 7.5f);
        this.body.addChild((BasicModelPart)this.left_Leg);
        this.left_Leg.setTextureOffset(38, 35).addBox(-3.0f, 0.5f, -3.0f, 6.0f, 6.0f, 6.0f, scale, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (alpha * this.alpha > 0.0f || this.ignoreColor) {
            float alphaIn;
            float redIn = this.ignoreColor ? 1.0f : red * this.red;
            float greenIn = this.ignoreColor ? 1.0f : green * this.green;
            float blueIn = this.ignoreColor ? 1.0f : blue * this.blue;
            float f = alphaIn = this.ignoreColor ? 1.0f : alpha * this.alpha;
            if (this.f_102610_) {
                float f2 = 1.5f;
                this.head.setScale(f2, f2, f2);
                this.head.setShouldScaleChildren(true);
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                matrixStackIn.m_85837_(0.0, 1.5, 0.0);
                this.parts().forEach(part -> part.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, redIn, greenIn, blueIn, alphaIn));
                matrixStackIn.m_85849_();
                this.head.setScale(1.0f, 1.0f, 1.0f);
            } else {
                matrixStackIn.m_85836_();
                this.parts().forEach(part -> part.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, redIn, greenIn, blueIn, alphaIn));
                matrixStackIn.m_85849_();
            }
        }
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main, (Object)this.head, (Object)this.body, (Object)this.nose, (Object)this.tail, (Object)this.left_Arm, (Object)this.right_Arm, (Object)this.left_Ear, (Object)this.right_Ear, (Object)this.right_Leg, (Object)this.left_Leg);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(GummyBearEntity.ANIMATION_FISH);
        this.animator.startKeyframe(15);
        this.animator.move(this.body, 0.0f, 1.0f, 4.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.move(this.right_Arm, 0.0f, -2.0f, -1.0f);
        this.animator.move(this.left_Arm, 0.0f, -2.0f, -1.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -10.0f);
        this.animator.move(this.head, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-50.0), (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-50.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.move(this.right_Arm, 0.0f, 0.0f, -2.0f);
        this.animator.move(this.left_Arm, 0.0f, 0.0f, -2.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.head, 0.0f, -2.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-30.0), (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-30.0), (float)Math.toRadians(10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GummyBearEntity.ANIMATION_EAT);
        this.animator.startKeyframe(5);
        this.animator.move(this.head, 0.0f, 3.0f, 1.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.move(this.right_Arm, -1.0f, 0.0f, 3.0f);
        this.animator.move(this.left_Arm, 1.0f, 0.0f, 3.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(30);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GummyBearEntity.ANIMATION_BACKSCRATCH);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, 3.0f);
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(80);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GummyBearEntity.ANIMATION_MAUL);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-70.0), 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-70.0), 0.0f, (float)Math.toRadians(20.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.head, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(20.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(6);
        this.animator.setAnimation(GummyBearEntity.ANIMATION_SWIPE);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -2.0f);
        this.animator.move(this.right_Arm, 0.0f, 0.0f, -2.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(-10.0), (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-60.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -2.0f);
        this.animator.move(this.right_Arm, 0.0f, 0.0f, -2.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(-10.0), (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-60.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, -4.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(GummyBearEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float animationIntensity;
        this.resetToDefaultPose();
        this.animate(entity);
        boolean november13th = entity.lookForTheGummyBearAlbumInStoresOnNovember13th;
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float walkSpeed = 0.5f;
        float walkDegree = 1.0f;
        float bounceSpeed = 1.0f;
        float bounceDegree = 1.0f;
        float headYawAmount = netHeadYaw / 57.295776f;
        float headPitchAmount = headPitch / 57.295776f;
        float sleepProgress = entity.getSleepProgress(partialTicks);
        float danceProgress = (1.0f - sleepProgress) * entity.getDanceProgress(partialTicks);
        float sitProgress = (1.0f - sleepProgress) * Math.max(entity.getSitProgress(partialTicks), danceProgress);
        float standProgress = (1.0f - sleepProgress) * (1.0f - sitProgress) * (november13th ? Math.min(1.0f, limbSwingAmount * entity.getStandProgress(partialTicks)) : entity.getStandProgress(partialTicks));
        float uprightProgress = Math.max(sitProgress, standProgress);
        float allFoursProgress = 1.0f - uprightProgress;
        this.progressRotationPrev(this.body, uprightProgress, (float)Math.toRadians(-90.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, uprightProgress, (float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.head, uprightProgress, 0.0f, -4.0f, -4.0f, 1.0f);
        this.progressPositionPrev(this.body, sitProgress, 0.0f, 2.5f, 2.5f, 1.0f);
        this.progressPositionPrev(this.body, standProgress, 0.0f, -2.8f, 0.0f, 1.0f);
        this.progressPositionPrev(this.left_Leg, standProgress, 0.0f, -2.5f, 2.0f, 1.0f);
        this.progressPositionPrev(this.right_Leg, standProgress, 0.0f, -2.5f, 2.0f, 1.0f);
        this.progressPositionPrev(this.tail, standProgress, 0.0f, -2.5f, 0.0f, 1.0f);
        if (november13th) {
            this.progressRotationPrev(this.left_Leg, standProgress, (float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.right_Leg, standProgress, (float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.right_Arm, standProgress, 0.0f, 0.0f, (float)Math.toRadians(60.0), 1.0f);
            this.progressRotationPrev(this.left_Arm, standProgress, 0.0f, 0.0f, (float)Math.toRadians(-60.0), 1.0f);
        } else {
            this.progressRotationPrev(this.body, standProgress, (float)Math.toRadians(10.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.head, standProgress, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.left_Leg, standProgress, (float)Math.toRadians(80.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.right_Leg, standProgress, (float)Math.toRadians(80.0), 0.0f, 0.0f, 1.0f);
        }
        this.progressRotationPrev(this.right_Arm, sleepProgress, (float)Math.toRadians(-30.0), 0.0f, (float)Math.toRadians(90.0), 1.0f);
        this.progressRotationPrev(this.left_Arm, sleepProgress, (float)Math.toRadians(-30.0), 0.0f, (float)Math.toRadians(-90.0), 1.0f);
        this.progressRotationPrev(this.head, sleepProgress, (float)Math.toRadians(10.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(10.0), 1.0f);
        this.progressRotationPrev(this.right_Leg, sleepProgress, (float)Math.toRadians(30.0), 0.0f, (float)Math.toRadians(90.0), 1.0f);
        this.progressRotationPrev(this.left_Leg, sleepProgress, (float)Math.toRadians(30.0), 0.0f, (float)Math.toRadians(-90.0), 1.0f);
        this.progressPositionPrev(this.body, sleepProgress, 0.0f, 5.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.right_Arm, sleepProgress, -1.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.left_Arm, sleepProgress, 1.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.head, sleepProgress, 0.0f, -1.0f, 1.0f, 1.0f);
        this.progressPositionPrev(this.right_Leg, sleepProgress, -1.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.left_Leg, sleepProgress, 1.0f, -2.0f, 0.0f, 1.0f);
        this.flap(this.tail, 0.06f, 0.1f, false, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.left_Ear, 0.06f, 0.1f, false, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.right_Ear, 0.06f, 0.1f, true, -1.0f, 0.0f, ageInTicks, 1.0f);
        this.bob(this.head, 0.06f, 0.2f, false, ageInTicks, 1.0f);
        this.flap(this.right_Leg, 0.06f, 0.2f, false, -1.0f, 0.2f, ageInTicks, sitProgress);
        this.flap(this.left_Leg, 0.06f, 0.2f, true, -1.0f, 0.2f, ageInTicks, sitProgress);
        this.walk(this.right_Arm, 0.06f, 0.1f, false, -2.0f, 0.2f, ageInTicks, sitProgress);
        this.walk(this.left_Arm, 0.06f, 0.1f, false, -2.0f, 0.2f, ageInTicks, sitProgress);
        this.walk(this.right_Arm, 0.06f, 0.1f, false, -2.0f, 0.4f, ageInTicks, standProgress);
        this.walk(this.left_Arm, 0.06f, 0.1f, false, -2.0f, 0.4f, ageInTicks, standProgress);
        this.flap(this.body, 0.3f, 0.1f, false, -2.0f, 0.0f, ageInTicks, danceProgress);
        this.bob(this.body, 0.3f, 7.0f, true, ageInTicks, danceProgress);
        this.flap(this.head, 0.3f, 0.1f, false, -2.0f, 0.0f, ageInTicks, danceProgress);
        this.swing(this.head, 0.3f, 0.1f, false, -2.0f, 0.0f, ageInTicks, danceProgress);
        this.walk(this.left_Arm, 0.3f, 0.5f, true, -2.0f, 0.5f, ageInTicks, danceProgress);
        this.walk(this.right_Arm, 0.3f, 0.5f, false, -2.0f, -0.5f, ageInTicks, danceProgress);
        this.walk(this.left_Leg, 0.3f, 0.3f, true, -1.5f, -0.1f, ageInTicks, danceProgress);
        this.walk(this.right_Leg, 0.3f, 0.3f, true, -1.5f, -0.1f, ageInTicks, danceProgress);
        if (november13th) {
            this.walk(this.body, bounceSpeed, bounceDegree * 0.1f, true, 1.0f, -0.1f, limbSwing, limbSwingAmount);
            this.walk(this.left_Leg, bounceSpeed, bounceDegree, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.right_Leg, bounceSpeed, bounceDegree, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.right_Arm, bounceSpeed, bounceDegree, true, 2.0f, 0.3f, limbSwing, limbSwingAmount);
            this.walk(this.left_Arm, bounceSpeed, bounceDegree, true, 2.0f, 0.3f, limbSwing, limbSwingAmount);
            this.body.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, bounceSpeed, 0.4f, bounceDegree * 15.0f, false));
            this.body.rotationPointZ += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, bounceSpeed, 0.8f, bounceDegree * 6.0f, false));
        } else {
            this.flap(this.body, walkSpeed * 2.0f, walkDegree * 0.1f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.head, walkSpeed * 2.0f, walkDegree * 0.1f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.left_Leg, walkSpeed, walkDegree, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.left_Leg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, walkDegree * 2.0f, true));
            this.walk(this.right_Leg, walkSpeed, walkDegree, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.right_Leg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, walkDegree * 2.0f, false));
            this.walk(this.left_Arm, walkSpeed, walkDegree, false, 2.5f, 0.0f, limbSwing, limbSwingAmount * allFoursProgress);
            this.left_Arm.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount * allFoursProgress, walkSpeed, 1.0f, walkDegree * 2.0f, true));
            this.walk(this.right_Arm, walkSpeed, walkDegree, true, 2.5f, 0.0f, limbSwing, limbSwingAmount * allFoursProgress);
            this.right_Arm.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount * allFoursProgress, walkSpeed, 1.0f, walkDegree * 2.0f, false));
        }
        if (entity.getAnimation() == GummyBearEntity.ANIMATION_EAT) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 4.0f, GummyBearEntity.ANIMATION_EAT, partialTicks, 0);
            this.walk(this.head, 0.5f, 0.3f, true, 0.0f, 0.2f, ageInTicks, animationIntensity);
            this.walk(this.left_Arm, 0.5f, 0.3f, true, 1.0f, 0.2f, ageInTicks, animationIntensity);
            this.walk(this.right_Arm, 0.5f, 0.3f, true, 1.0f, 0.2f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == GummyBearEntity.ANIMATION_BACKSCRATCH) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 4.0f, GummyBearEntity.ANIMATION_BACKSCRATCH, partialTicks, 0);
            float bodyScratchUp = animationIntensity * 2.0f - ACMath.walkValue(ageInTicks, animationIntensity, 0.45f, -0.5f, 2.0f, true);
            this.body.rotationPointY += bodyScratchUp;
            this.left_Leg.rotationPointZ -= bodyScratchUp;
            this.right_Leg.rotationPointZ -= bodyScratchUp;
            this.walk(this.body, 0.45f, 0.1f, true, 0.0f, 0.2f, ageInTicks, animationIntensity);
            this.walk(this.left_Leg, 0.45f, 0.1f, false, 0.0f, 0.2f, ageInTicks, animationIntensity);
            this.walk(this.right_Leg, 0.45f, 0.1f, false, 0.0f, 0.2f, ageInTicks, animationIntensity);
            this.walk(this.head, 0.45f, 0.1f, true, 1.0f, 0.1f, ageInTicks, animationIntensity);
            this.flap(this.right_Arm, 0.45f, 0.1f, true, 1.0f, -0.3f, ageInTicks, animationIntensity);
            this.flap(this.left_Arm, 0.45f, 0.1f, true, 1.0f, 0.3f, ageInTicks, animationIntensity);
        }
        this.head.rotateAngleY += headYawAmount * 0.65f;
        this.head.rotateAngleX += headPitchAmount * 0.75f;
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack matrixStackIn) {
        this.main.translateAndRotate(matrixStackIn);
        this.body.translateAndRotate(matrixStackIn);
        if (humanoidArm == HumanoidArm.RIGHT) {
            this.right_Arm.translateAndRotate(matrixStackIn);
        } else {
            this.left_Arm.translateAndRotate(matrixStackIn);
        }
    }
}

