/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;

public class CorrodentModel
extends AdvancedEntityModel<CorrodentEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox chest;
    private final AdvancedModelBox head;
    private final AdvancedModelBox rwhisker_S;
    private final AdvancedModelBox rwhisker;
    private final AdvancedModelBox lwhisker_S;
    private final AdvancedModelBox lwhisker;
    private final AdvancedModelBox snout;
    private final AdvancedModelBox nose;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rarmPivot;
    private final AdvancedModelBox larmPivot;
    private final AdvancedModelBox hipsPivot;
    private final AdvancedModelBox hips;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox rlegPivot;
    private final AdvancedModelBox llegPivot;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox lleg;
    private final ModelAnimator animator;

    public CorrodentModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.chest = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chest.setRotationPoint(0.0f, -7.0f, 5.0f);
        this.root.addChild((BasicModelPart)this.chest);
        this.chest.setTextureOffset(0, 46).addBox(-1.0f, -10.0f, -7.0f, 2.0f, 5.0f, 14.0f, 0.0f, false);
        this.chest.setTextureOffset(0, 23).addBox(-4.0f, -5.0f, -7.0f, 8.0f, 9.0f, 14.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, 0.0f, -6.5f);
        this.chest.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(30, 28).addBox(-5.0f, -4.0f, -3.5f, 1.0f, 1.0f, 2.0f, 0.0f, true);
        this.head.setTextureOffset(50, 0).addBox(-5.0f, -3.0f, -7.5f, 10.0f, 6.0f, 7.0f, 0.0f, false);
        this.head.setTextureOffset(30, 28).addBox(4.0f, -4.0f, -3.5f, 1.0f, 1.0f, 2.0f, 0.0f, false);
        this.rwhisker_S = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rwhisker_S.setRotationPoint(4.5f, -8.0f, -2.5f);
        this.head.addChild((BasicModelPart)this.rwhisker_S);
        this.rwhisker_S.setTextureOffset(0, 62).addBox(0.0f, -5.0f, -3.0f, 0.0f, 10.0f, 6.0f, 0.0f, false);
        this.rwhisker = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rwhisker.setRotationPoint(4.0f, -3.0f, -7.0f);
        this.head.addChild((BasicModelPart)this.rwhisker);
        this.rwhisker.setTextureOffset(0, 17).addBox(0.0f, -10.0f, -0.5f, 0.0f, 10.0f, 6.0f, 0.0f, false);
        this.lwhisker_S = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lwhisker_S.setRotationPoint(-4.5f, -8.0f, -2.5f);
        this.head.addChild((BasicModelPart)this.lwhisker_S);
        this.lwhisker_S.setTextureOffset(0, 62).addBox(0.0f, -5.0f, -3.0f, 0.0f, 10.0f, 6.0f, 0.0f, true);
        this.lwhisker = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lwhisker.setRotationPoint(-4.0f, -3.0f, -7.0f);
        this.head.addChild((BasicModelPart)this.lwhisker);
        this.lwhisker.setTextureOffset(0, 17).addBox(0.0f, -10.0f, -0.5f, 0.0f, 10.0f, 6.0f, 0.0f, true);
        this.snout = new AdvancedModelBox((AdvancedEntityModel)this);
        this.snout.setRotationPoint(0.0f, -3.0f, -6.0f);
        this.head.addChild((BasicModelPart)this.snout);
        this.snout.setTextureOffset(30, 7).addBox(-2.0f, 3.0f, -9.5f, 4.0f, 7.0f, 0.0f, 0.0f, false);
        this.snout.setTextureOffset(48, 28).addBox(-3.0f, -2.0f, -9.5f, 6.0f, 5.0f, 10.0f, 0.0f, false);
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this);
        this.nose.setRotationPoint(0.0f, -1.5f, -9.25f);
        this.snout.addChild((BasicModelPart)this.nose);
        this.nose.setTextureOffset(0, 9).addBox(-2.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, 0.0f, -7.5f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(53, 43).addBox(-3.0f, 0.0f, -8.0f, 6.0f, 3.0f, 9.0f, -0.01f, false);
        this.jaw.setTextureOffset(32, 51).addBox(-3.0f, -2.99f, -8.0f, 6.0f, 3.0f, 9.0f, -0.01f, false);
        this.jaw.setScale(0.99f, 0.99f, 0.99f);
        this.rarmPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarmPivot.setRotationPoint(4.0f, 2.25f, -3.5f);
        this.chest.addChild((BasicModelPart)this.rarmPivot);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarmPivot.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(0, 0).addBox(-1.0f, -1.25f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, true);
        this.rarm.setTextureOffset(23, 0).addBox(-1.0f, 4.75f, -5.5f, 7.0f, 0.0f, 7.0f, 0.0f, true);
        this.larmPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larmPivot.setRotationPoint(-4.0f, 2.25f, -3.5f);
        this.chest.addChild((BasicModelPart)this.larmPivot);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larmPivot.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(0, 0).addBox(-2.0f, -1.25f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, false);
        this.larm.setTextureOffset(23, 0).addBox(-6.0f, 4.75f, -5.5f, 7.0f, 0.0f, 7.0f, 0.0f, false);
        this.hipsPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hipsPivot.setRotationPoint(0.0f, 0.0f, 7.0f);
        this.chest.addChild((BasicModelPart)this.hipsPivot);
        this.hips = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hipsPivot.addChild((BasicModelPart)this.hips);
        this.hips.setTextureOffset(30, 32).addBox(-1.0f, -10.0f, 0.0f, 2.0f, 5.0f, 14.0f, -0.01f, false);
        this.hips.setTextureOffset(0, 0).addBox(-4.0f, -5.0f, 0.0f, 8.0f, 9.0f, 14.0f, -0.01f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, -5.0f, 14.0f);
        this.hips.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(70, 8).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 5.0f, 14.0f, 0.0f, false);
        this.rlegPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rlegPivot.setRotationPoint(4.0f, 2.25f, 11.5f);
        this.hips.addChild((BasicModelPart)this.rlegPivot);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rlegPivot.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(0, 0).addBox(-1.0f, -1.25f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, true);
        this.rleg.setTextureOffset(23, 0).addBox(-1.0f, 4.75f, -5.5f, 7.0f, 0.0f, 7.0f, 0.0f, true);
        this.llegPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.llegPivot.setRotationPoint(-4.0f, 2.25f, 11.5f);
        this.hips.addChild((BasicModelPart)this.llegPivot);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.llegPivot.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(0, 0).addBox(-2.0f, -1.25f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f, false);
        this.lleg.setTextureOffset(23, 0).addBox(-6.0f, 4.75f, -5.5f, 7.0f, 0.0f, 7.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.rarmPivot, (Object)this.larmPivot, (Object)this.rarm, (Object)this.larm, (Object)this.chest, (Object)this.hips, (Object)this.hipsPivot, (Object)this.llegPivot, (Object)this.rlegPivot, (Object)this.lleg, (Object)this.rleg, (Object[])new AdvancedModelBox[]{this.head, this.snout, this.nose, this.tail, this.lwhisker, this.lwhisker_S, this.rwhisker, this.rwhisker_S, this.jaw});
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(CorrodentEntity.ANIMATION_BITE);
        this.animator.startKeyframe(5);
        this.animator.move(this.head, 0.0f, 0.0f, 4.0f);
        this.animator.move(this.chest, 0.0f, 0.0f, 4.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(-5.0));
        this.animator.rotate(this.snout, (float)Math.toRadians(-35.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(45.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(25.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.chest, 0.0f, 0.0f, -2.0f);
        this.animator.move(this.jaw, 0.0f, 0.0f, 1.0f);
        this.animator.rotate(this.snout, (float)Math.toRadians(5.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(45.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(CorrodentEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float walkSpeed = 1.0f;
        float walkDegree = 1.0f;
        float digSpeed = 1.0f;
        float digDegree = 1.0f;
        float stillAmount = 1.0f - limbSwingAmount;
        float digAmount = entity.getDigAmount(partialTicks);
        float afraidAmount = entity.getAfraidAmount(partialTicks);
        float walkAmount = (1.0f - digAmount) * limbSwingAmount * (1.0f + afraidAmount);
        float digLimbAmount = limbSwingAmount * digAmount;
        float twitchinessAmount = ACMath.smin((float)Math.sin(ageInTicks * 0.1f) + 0.5f, 0.0f, 0.3f);
        float digPitch = entity.getDigPitch(partialTicks);
        this.progressRotationPrev(this.tail, stillAmount, (float)Math.toRadians(-20.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.chest, afraidAmount, 0.0f, -2.5f, 0.0f, 1.0f);
        this.progressPositionPrev(this.hips, afraidAmount, 0.0f, -2.45f, -3.0f, 1.0f);
        this.progressPositionPrev(this.head, afraidAmount, 0.0f, -1.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.chest, afraidAmount, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, afraidAmount, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.larm, afraidAmount, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, afraidAmount, (float)Math.toRadians(-40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.hips, afraidAmount, (float)Math.toRadians(-80.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, afraidAmount, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, afraidAmount, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail, afraidAmount, (float)Math.toRadians(70.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.snout, afraidAmount, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.jaw, afraidAmount, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, digAmount, (float)Math.toRadians(-35.0), (float)Math.toRadians(-45.0), (float)Math.toRadians(-45.0), 1.0f);
        this.progressRotationPrev(this.larm, digAmount, (float)Math.toRadians(-35.0), (float)Math.toRadians(45.0), (float)Math.toRadians(45.0), 1.0f);
        this.progressRotationPrev(this.rleg, digAmount, (float)Math.toRadians(-35.0), (float)Math.toRadians(-45.0), (float)Math.toRadians(-45.0), 1.0f);
        this.progressRotationPrev(this.lleg, digAmount, (float)Math.toRadians(-35.0), (float)Math.toRadians(45.0), (float)Math.toRadians(45.0), 1.0f);
        this.progressPositionPrev(this.rarm, digAmount, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.larm, digAmount, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rleg, digAmount, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.lleg, digAmount, 0.0f, -2.0f, 0.0f, 1.0f);
        this.walk(this.head, 0.1f, 0.05f, true, 1.0f, 0.1f, ageInTicks, 1.0f);
        this.swing(this.tail, 0.1f, 0.05f, true, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.snout, 1.0f, 0.1f, true, 1.0f, -0.3f, ageInTicks, twitchinessAmount);
        this.walk(this.jaw, 1.0f, 0.1f, true, 1.0f, -0.2f, ageInTicks, twitchinessAmount);
        this.walk(this.nose, 2.5f, 0.1f, true, 1.0f, -0.4f, ageInTicks, twitchinessAmount);
        this.flap(this.lwhisker, 1.5f, 0.3f, false, 1.0f, 1.0f, ageInTicks, twitchinessAmount);
        this.flap(this.rwhisker, 1.5f, 0.3f, true, 1.0f, 1.0f, ageInTicks, twitchinessAmount);
        this.flap(this.head, 0.3f, 0.3f, true, 1.0f, 0.0f, ageInTicks, afraidAmount);
        this.swing(this.head, 0.3f, 0.2f, true, 2.0f, 0.0f, ageInTicks, afraidAmount);
        this.flap(this.lwhisker, 0.15f, 0.4f, false, 1.0f, -1.0f, ageInTicks, afraidAmount);
        this.flap(this.rwhisker, 0.15f, 0.4f, true, 1.0f, -1.0f, ageInTicks, afraidAmount);
        this.walk(this.head, walkSpeed, walkDegree * 0.05f, true, 1.0f, 0.1f, limbSwing, walkAmount);
        this.flap(this.chest, walkSpeed, walkDegree * 0.1f, true, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.hips, walkSpeed, walkDegree * 0.1f, true, 2.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.lleg, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.rleg, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.larm, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.rarm, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.flap(this.head, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, walkAmount);
        this.swing(this.tail, walkSpeed, walkDegree * 0.4f, false, -1.0f, 0.0f, limbSwing, walkAmount);
        float bodyBob = ACMath.walkValue(limbSwing, walkAmount, walkSpeed * 1.5f, 0.5f, 1.0f, true);
        this.chest.rotationPointY += bodyBob;
        this.walk(this.rarm, walkSpeed, walkDegree, false, -1.5f, 0.0f, limbSwing, walkAmount);
        this.rarm.rotateAngleZ -= this.chest.rotateAngleZ * walkAmount;
        this.rarm.rotationPointY -= bodyBob - Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -1.5f, 4.0f, true)) + walkAmount;
        this.walk(this.larm, walkSpeed, walkDegree, true, -1.5f, 0.0f, limbSwing, walkAmount);
        this.larm.rotateAngleZ -= this.chest.rotateAngleZ * walkAmount;
        this.larm.rotationPointY -= bodyBob - Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -1.5f, 4.0f, false)) + walkAmount;
        this.walk(this.rleg, walkSpeed, walkDegree, true, -2.5f, 0.0f, limbSwing, walkAmount);
        this.rleg.rotateAngleZ -= (this.chest.rotateAngleZ + this.hips.rotateAngleZ) * walkAmount;
        this.rleg.rotationPointY -= bodyBob - Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -2.5f, 4.0f, false)) + walkAmount;
        this.walk(this.lleg, walkSpeed, walkDegree, false, -2.5f, 0.0f, limbSwing, walkAmount);
        this.lleg.rotateAngleZ -= (this.chest.rotateAngleZ + this.hips.rotateAngleZ) * walkAmount;
        this.lleg.rotationPointY -= bodyBob - Math.min(0.0f, ACMath.walkValue(limbSwing, walkAmount, walkSpeed, -2.5f, 4.0f, true)) + walkAmount;
        this.swing(this.chest, digSpeed * 0.5f, digDegree * 0.1f, false, 2.0f, 0.0f, limbSwing, digLimbAmount);
        this.swing(this.hips, digSpeed * 0.5f, digDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, digLimbAmount);
        this.swing(this.tail, digSpeed * 0.5f, digDegree * 0.1f, false, 0.0f, 0.0f, limbSwing, digLimbAmount);
        this.swing(this.rarmPivot, digSpeed, digDegree, false, 1.0f, -0.3f, limbSwing, digLimbAmount);
        this.walk(this.rarmPivot, digSpeed, digDegree * 0.5f, false, 2.0f, 0.0f, limbSwing, digLimbAmount);
        this.flap(this.rarmPivot, digSpeed, digDegree, false, 3.0f, 0.0f, limbSwing, digLimbAmount);
        this.swing(this.larmPivot, digSpeed, digDegree, false, 1.0f, 0.3f, limbSwing, digLimbAmount);
        this.walk(this.larmPivot, digSpeed, digDegree * 0.5f, true, 2.0f, 0.0f, limbSwing, digLimbAmount);
        this.flap(this.larmPivot, digSpeed, digDegree, false, 3.0f, 0.0f, limbSwing, digLimbAmount);
        this.swing(this.llegPivot, digSpeed, digDegree, false, -1.0f, 0.3f, limbSwing, digLimbAmount);
        this.walk(this.llegPivot, digSpeed, digDegree * 0.5f, false, -2.0f, 0.0f, limbSwing, digLimbAmount);
        this.flap(this.llegPivot, digSpeed, digDegree, false, -2.0f, 0.0f, limbSwing, digLimbAmount);
        this.swing(this.rlegPivot, digSpeed, digDegree, false, -1.0f, -0.3f, limbSwing, digLimbAmount);
        this.walk(this.rlegPivot, digSpeed, digDegree * 0.5f, true, -2.0f, 0.0f, limbSwing, digLimbAmount);
        this.flap(this.rlegPivot, digSpeed, digDegree, false, 3.0f, 0.0f, limbSwing, digLimbAmount);
        this.walk(this.head, digSpeed * 4.0f, digDegree * 0.15f, true, 4.0f, -0.05f, limbSwing, digLimbAmount);
        this.walk(this.jaw, digSpeed * 4.0f, digDegree * 0.15f, true, 4.0f, -0.25f, limbSwing, digLimbAmount);
        float headPitchAmount = headPitch / 57.295776f;
        this.head.rotateAngleX += headPitchAmount;
        double defaultX = Mth.m_14177_((float)digPitch);
        double defaultY = Mth.m_14177_((float)(entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks));
        double tailX = (double)entity.getTrailTransformation(5, 0, partialTicks) - defaultX;
        double tail1Y = (double)entity.getTrailTransformation(5, 1, partialTicks) - defaultY;
        double tail2Y = (double)entity.getTrailTransformation(10, 1, partialTicks) - defaultY;
        this.chest.rotateAngleX = (float)((double)this.chest.rotateAngleX + Math.toRadians(digPitch));
        this.hipsPivot.rotateAngleY = (float)((double)this.hipsPivot.rotateAngleY + Math.toRadians(Mth.m_14175_((double)tail1Y)) * (double)(1.0f - afraidAmount));
        this.tail.rotateAngleY = (float)((double)this.tail.rotateAngleY + Math.toRadians(Mth.m_14175_((double)tail2Y)));
        this.hipsPivot.rotateAngleX = (float)((double)this.hipsPivot.rotateAngleX + Math.toRadians(Mth.m_14175_((double)tailX)) * (double)(1.0f - afraidAmount));
        this.head.rotateAngleY = (float)((double)this.head.rotateAngleY + Math.toRadians((double)Mth.m_14148_((float)((float)defaultY), (float)((float)((double)netHeadYaw + defaultY)), (float)20.0f) - defaultY));
    }
}

