/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.data;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.venturecraft.gliders.data.forge.GliderDataImpl;
import net.venturecraft.gliders.network.SyncGliderData;
import net.venturecraft.gliders.util.GliderUtil;
import org.jetbrains.annotations.NotNull;

public class GliderData {
    @NotNull
    private final Player player;
    public AnimationState glideAnimation = new AnimationState();
    public AnimationState fallingAnimation = new AnimationState();
    public AnimationState gliderOpeningAnimation = new AnimationState();
    private boolean isGliding = false;
    private int lightningTimer = 0;

    public GliderData(@NotNull Player player) {
        this.player = player;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<GliderData> get(LivingEntity player) {
        return GliderDataImpl.get(player);
    }

    public void tick(LivingEntity livingEntity) {
        this.glideAndFallLogic(livingEntity);
        GliderUtil.onTickPlayerGlide(livingEntity.m_9236_(), livingEntity);
        if (!GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            this.setLightningTimer(0);
        }
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        this.setGliding(GliderUtil.isGlidingWithActiveGlider(livingEntity));
        if (livingEntity.f_19797_ % 40 == 0) {
            this.sync();
        }
    }

    private boolean isGliding() {
        return this.isGliding;
    }

    private void setGliding(boolean glidingWithActiveGlider) {
        this.isGliding = glidingWithActiveGlider;
    }

    private void glideAndFallLogic(LivingEntity livingEntity) {
        if (this.isGliding() || GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            if (!this.glideAnimation.m_216984_()) {
                this.glideAnimation.m_216977_(livingEntity.f_19797_);
            }
            if (!this.gliderOpeningAnimation.m_216984_()) {
                this.gliderOpeningAnimation.m_216977_(livingEntity.f_19797_);
            }
        } else {
            this.glideAnimation.m_216973_();
            this.gliderOpeningAnimation.m_216973_();
        }
    }

    public void sync() {
        if (this.player.m_9236_().f_46443_) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        new SyncGliderData(this.player.m_19879_(), this.serializeNBT()).sendToTracking((Entity)this.player);
    }

    public void syncTo(ServerPlayer receiver) {
        if (this.player.m_9236_().f_46443_) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        new SyncGliderData(this.player.m_19879_(), this.serializeNBT()).send(receiver);
    }

    public AnimationState getAnimation(AnimationStates animationStates) {
        return switch (animationStates) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationStates.FALLING -> this.fallingAnimation;
            case AnimationStates.GLIDING -> this.glideAnimation;
            case AnimationStates.GLIDER_OPENING -> this.gliderOpeningAnimation;
        };
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128379_("is_gliding", this.isGliding);
        compoundTag.m_128405_("lightningTimer", this.lightningTimer);
        return compoundTag;
    }

    public int lightningTimer() {
        return this.lightningTimer;
    }

    public GliderData setLightningTimer(int lightningTimer) {
        this.lightningTimer = lightningTimer;
        return this;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setGliding(nbt.m_128471_("is_gliding"));
        this.setLightningTimer(nbt.m_128451_("lightningTimer"));
    }

    public static enum AnimationStates {
        FALLING,
        GLIDING,
        GLIDER_OPENING;

    }
}

