/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.threetag.palladiumcore.item.IPalladiumItem;
import net.venturecraft.gliders.util.ModConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GliderItem
extends Item
implements IPalladiumItem {
    private final Supplier<ItemStack> repair;

    public GliderItem(Item.Properties itemProperties, Supplier<ItemStack> stackSupplier) {
        super(itemProperties);
        this.repair = stackSupplier;
    }

    public static boolean isSpaceGlider(ItemStack stack) {
        return stack.m_41611_().getString().contains("xwing");
    }

    public static ItemStack setCopper(ItemStack itemStack, boolean copper) {
        CompoundTag compound = itemStack.m_41784_();
        compound.m_128379_("copper_upgrade", copper);
        return itemStack;
    }

    public static boolean hasCopperUpgrade(ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41784_();
        if (!compound.m_128441_("copper_upgrade")) {
            return false;
        }
        return compound.m_128471_("copper_upgrade");
    }

    public static ItemStack setNether(ItemStack itemStack, boolean copper) {
        CompoundTag compound = itemStack.m_41784_();
        compound.m_128379_("nether_upgrade", copper);
        return itemStack;
    }

    public static boolean hasNetherUpgrade(ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41784_();
        if (!compound.m_128441_("nether_upgrade")) {
            return false;
        }
        return compound.m_128471_("nether_upgrade");
    }

    public static boolean isGlidingEnabled(ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41784_();
        if (!compound.m_128441_("glide")) {
            return false;
        }
        return compound.m_128471_("glide") && !GliderItem.isBroken(itemStack);
    }

    public static boolean isTooBroken(ItemStack itemStack) {
        return itemStack.m_41773_() >= itemStack.m_41776_() - 1;
    }

    public static void setGlide(ItemStack itemStack, boolean canGlide) {
        CompoundTag compound = itemStack.m_41784_();
        compound.m_128379_("glide", canGlide);
    }

    public static void setBroken(ItemStack itemStack, boolean broken) {
        CompoundTag compound = itemStack.m_41784_();
        compound.m_128379_("broken", broken);
    }

    public static boolean isBroken(ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41784_();
        if (!compound.m_128441_("broken")) {
            return false;
        }
        return compound.m_128471_("broken");
    }

    public static void setStruck(ItemStack itemStack, boolean isStruck) {
        CompoundTag compound = itemStack.m_41784_();
        compound.m_128379_("struck", isStruck);
    }

    public static boolean hasBeenStruck(ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41784_();
        if (!compound.m_128441_("struck")) {
            return false;
        }
        return compound.m_128471_("struck");
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.m_41720_() == this.repair.get().m_41720_();
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (GliderItem.hasCopperUpgrade(stack) || GliderItem.hasNetherUpgrade(stack)) {
            tooltip.add((Component)Component.m_237115_((String)ModConstants.INSTALLED_UPGRADES));
            if (GliderItem.hasCopperUpgrade(stack)) {
                tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)ModConstants.COPPER_UPGRADE)));
            }
            if (GliderItem.hasNetherUpgrade(stack)) {
                tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)ModConstants.NETHER_UPGRADE)));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
        ItemStack equipmentSlotStack = player.m_6844_(equipmentslot);
        if (equipmentSlotStack.m_41619_()) {
            player.m_8061_(equipmentslot, itemstack.m_41777_());
            if (!level.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemstack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }
}

