/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import satisfy.herbalbrews.HerbalBrews;
import satisfy.herbalbrews.effects.ArmorEffect;
import satisfy.herbalbrews.effects.BalancedEffect;
import satisfy.herbalbrews.effects.DamageEffect;
import satisfy.herbalbrews.effects.ExcavationEffect;
import satisfy.herbalbrews.effects.FeralEffect;
import satisfy.herbalbrews.effects.FortuneEffect;
import satisfy.herbalbrews.effects.PoisonousbreathEffect;
import satisfy.herbalbrews.effects.RenewalEffect;
import satisfy.herbalbrews.effects.RevitalizingEffect;
import satisfy.herbalbrews.effects.ToughEffect;
import satisfy.herbalbrews.util.HerbalBrewsIdentifier;

public class EffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> BALANCED;
    public static final RegistrySupplier<MobEffect> FERAL;
    public static final RegistrySupplier<MobEffect> ARMOR;
    public static final RegistrySupplier<MobEffect> DAMAGE;
    public static final RegistrySupplier<MobEffect> FORTUNE;
    public static final RegistrySupplier<MobEffect> EXCAVATION;
    public static final RegistrySupplier<MobEffect> POISONOUSBREATH;
    public static final RegistrySupplier<MobEffect> RENEWAL;
    public static final RegistrySupplier<MobEffect> REVITALIZING;
    public static final RegistrySupplier<MobEffect> TOUGH;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new HerbalBrewsIdentifier(name), effect);
    }

    public static void init() {
        HerbalBrews.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        RENEWAL = EffectRegistry.registerEffect("renewal", RenewalEffect::new);
        BALANCED = EffectRegistry.registerEffect("balanced", BalancedEffect::new);
        FORTUNE = EffectRegistry.registerEffect("fortune", FortuneEffect::new);
        FERAL = EffectRegistry.registerEffect("feral", FeralEffect::new);
        ARMOR = EffectRegistry.registerEffect("armor", ArmorEffect::new);
        DAMAGE = EffectRegistry.registerEffect("damage", DamageEffect::new);
        EXCAVATION = EffectRegistry.registerEffect("excavation", ExcavationEffect::new);
        TOUGH = EffectRegistry.registerEffect("tough", ToughEffect::new);
        REVITALIZING = EffectRegistry.registerEffect("revitalizing", RevitalizingEffect::new);
        POISONOUSBREATH = EffectRegistry.registerEffect("poisonous", PoisonousbreathEffect::new);
    }
}

