/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import satisfy.herbalbrews.client.gui.handler.CauldronGuiHandler;
import satisfy.herbalbrews.client.gui.handler.TeaKettleGuiHandler;
import satisfy.herbalbrews.compat.jei.category.CauldronCategory;
import satisfy.herbalbrews.compat.jei.category.TeaKettleCategory;
import satisfy.herbalbrews.registry.ObjectRegistry;
import satisfy.herbalbrews.registry.RecipeTypeRegistry;
import satisfy.herbalbrews.registry.ScreenHandlerTypeRegistry;
import satisfy.herbalbrews.util.HerbalBrewsIdentifier;

@JeiPlugin
public class HerbalBrewsJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TeaKettleCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List cookingCauldronRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get());
        registration.addRecipes(TeaKettleCategory.TEA_KETTLE, cookingCauldronRecipes);
        List cauldronRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CAULDRON_RECIPE_TYPE.get());
        registration.addRecipes(CauldronCategory.CAULDRON, cauldronRecipes);
    }

    public ResourceLocation getPluginUid() {
        return new HerbalBrewsIdentifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(TeaKettleGuiHandler.class, (MenuType)ScreenHandlerTypeRegistry.TEA_KETTLE_SCREEN_HANDLER.get(), TeaKettleCategory.TEA_KETTLE, 1, 6, 7, 36);
        registration.addRecipeTransferHandler(CauldronGuiHandler.class, (MenuType)ScreenHandlerTypeRegistry.CAULDRON_SCREEN_HANDLER.get(), CauldronCategory.CAULDRON, 1, 3, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.CAULDRON.get()).m_5456_().m_7968_(), new RecipeType[]{CauldronCategory.CAULDRON});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.TEA_KETTLE.get()).m_5456_().m_7968_(), new RecipeType[]{TeaKettleCategory.TEA_KETTLE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.COPPER_TEA_KETTLE.get()).m_5456_().m_7968_(), new RecipeType[]{TeaKettleCategory.TEA_KETTLE});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

