/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block;

import de.cristelknight.doapi.common.block.FacingBlock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.block.entity.SiloBlockEntity;
import net.satisfy.brewery.registry.BlockEntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.silo.ConnectivityHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiloBlock
extends FacingBlock
implements EntityBlock {
    public static final HashMap<Item, Item> DRYERS = new HashMap();
    private static boolean isDryersInitialized = false;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    static final VoxelShape CAMPFIRE_SMOKE_CLIP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SiloBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)((Object)Shape.NONE))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)f_54117_);
    }

    public BlockState setFacing(BlockState state, Direction facing) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)facing);
    }

    public static void addDry(ItemLike itemLike, ItemLike resultItem) {
        if (itemLike.m_5456_() != Items.f_41852_ && resultItem.m_5456_() != Items.f_41852_) {
            DRYERS.put(itemLike.m_5456_(), resultItem.m_5456_());
        }
    }

    public static boolean isSilo(ItemStack itemStack) {
        BlockItem bi;
        Item item = itemStack.m_41720_();
        return item instanceof BlockItem && ((bi = (BlockItem)item).m_40614_() == ObjectRegistry.SILO_WOOD.get() || bi.m_40614_() == ObjectRegistry.SILO_COPPER.get());
    }

    public static boolean isSilo(BlockState state) {
        return state.m_60734_() instanceof SiloBlock;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (level.f_46443_) {
            return itemStack.m_41619_() || SiloBlock.isDryItem(itemStack) ? InteractionResult.SUCCESS : (SiloBlock.isSilo(itemStack) || player.m_20163_() ? InteractionResult.PASS : InteractionResult.CONSUME);
        }
        BlockEntity be = level.m_7702_(blockPos);
        if (be instanceof SiloBlockEntity) {
            SiloBlockEntity siloBE = (SiloBlockEntity)be;
            SiloBlockEntity siloController = siloBE.getControllerBE();
            if (siloController == null) {
                return InteractionResult.PASS;
            }
            if (itemStack.m_41619_()) {
                if (player.m_20163_()) {
                    ItemStack returnStack = siloBE.tryRemoveItem();
                    if (!returnStack.m_41619_()) {
                        player.m_36356_(itemStack);
                    }
                } else {
                    siloController.open((Boolean)blockState.m_61143_((Property)OPEN) == false);
                }
                return InteractionResult.SUCCESS;
            }
            if (SiloBlock.isDryItem(itemStack) && siloController.tryAddItem(itemStack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return SiloBlock.isSilo(itemStack) || player.m_20163_() ? InteractionResult.PASS : InteractionResult.CONSUME;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (notify) {
            return;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof SiloBlockEntity) {
            SiloBlockEntity siloBlockEntity = (SiloBlockEntity)be;
            siloBlockEntity.updateConnectivity();
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean moved) {
        if (blockState.m_155947_() && (blockState.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = level.m_7702_(blockPos);
            if (!(be instanceof SiloBlockEntity)) {
                return;
            }
            SiloBlockEntity siloBE = (SiloBlockEntity)be;
            Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)siloBE);
            level.m_46747_(blockPos);
            ConnectivityHandler.splitMulti(siloBE);
        }
    }

    public boolean m_6104_(BlockState blockState, BlockState blockState2, Direction direction) {
        return blockState2.m_60713_((Block)this) || super.m_6104_(blockState, blockState2, direction);
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return level.m_141902_(blockPos, (BlockEntityType)BlockEntityRegistry.SILO.get()).map(AbstractContainerMenu::m_38938_).orElse(0);
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context == CollisionContext.m_82749_()) {
            return CAMPFIRE_SMOKE_CLIP;
        }
        return state.m_60808_(world, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TOP, BOTTOM, OPEN, SHAPE, f_54117_});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                ((BlockEntityTicker)blockEntity).m_155252_(world, pos, state1, blockEntity);
            }
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SiloBlockEntity(pos, state);
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        return switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case Shape.NORTH -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SOUTH));
            case Shape.NORTH_EAST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SOUTH_WEST));
            case Shape.EAST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WEST));
            case Shape.SOUTH_EAST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORTH_WEST));
            case Shape.SOUTH -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORTH));
            case Shape.SOUTH_WEST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORTH_EAST));
            case Shape.WEST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.EAST));
            case Shape.NORTH_WEST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SOUTH_EAST));
            default -> state;
        };
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        return switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case Shape.NORTH -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.EAST));
            case Shape.NORTH_EAST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SOUTH_EAST));
            case Shape.EAST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SOUTH));
            case Shape.SOUTH_EAST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.SOUTH_WEST));
            case Shape.SOUTH -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WEST));
            case Shape.SOUTH_WEST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORTH_WEST));
            case Shape.WEST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORTH));
            case Shape.NORTH_WEST -> (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.NORTH_EAST));
            default -> state;
        };
    }

    public static Map<Item, Item> getDryers() {
        return Collections.unmodifiableMap(DRYERS);
    }

    public static synchronized void initializeDryersIfNeeded() {
        if (!isDryersInitialized) {
            SiloBlock.addDry((ItemLike)ObjectRegistry.CORN.get(), (ItemLike)ObjectRegistry.DRIED_CORN.get());
            SiloBlock.addDry((ItemLike)ObjectRegistry.BARLEY.get(), (ItemLike)ObjectRegistry.DRIED_BARLEY.get());
            SiloBlock.addDry((ItemLike)Items.f_42405_, (ItemLike)ObjectRegistry.DRIED_WHEAT.get());
            isDryersInitialized = true;
        }
    }

    public static boolean isDryItem(ItemStack itemStack) {
        SiloBlock.initializeDryersIfNeeded();
        return DRYERS.containsKey(itemStack.m_41720_());
    }

    public static enum Shape implements StringRepresentable
    {
        NONE,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;


        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

