/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.block.HopsCropBodyBlock;
import net.satisfy.brewery.block.HopsCropHeadBlock;
import net.satisfy.brewery.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class HopsCropBlock
extends Block {
    protected final VoxelShape shape;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final int MAX_AGE = 3;

    protected HopsCropBlock(BlockBehaviour.Properties arg, VoxelShape shape) {
        super(arg);
        this.shape = shape;
    }

    public static HopsCropHeadBlock getHeadBlock() {
        return (HopsCropHeadBlock)((Object)ObjectRegistry.HOPS_CROP.get());
    }

    public static HopsCropBodyBlock getBodyBlock() {
        return (HopsCropBodyBlock)((Object)ObjectRegistry.HOPS_CROP_BODY.get());
    }

    protected static boolean isRopeAbove(LevelAccessor levelAccessor, BlockPos blockPos) {
        List results = levelAccessor.m_45976_(HangingRopeEntity.class, new AABB(blockPos.m_7494_(), blockPos.m_7494_().m_7918_(1, 8, 1)));
        for (HangingRopeEntity hangingRope : results) {
            if (!hangingRope.active()) continue;
            return true;
        }
        return false;
    }

    protected static int getHeight(BlockPos blockPos, LevelAccessor levelAccessor) {
        int height = 0;
        while (levelAccessor.m_8055_(blockPos.m_6625_(height)).m_60734_() instanceof HopsCropBlock) {
            ++height;
        }
        return height;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        return !blockState.m_60713_((Block)HopsCropBlock.getHeadBlock()) && !blockState.m_60713_((Block)HopsCropBlock.getBodyBlock()) ? this.m_49966_() : HopsCropBlock.getBodyBlock().m_49966_();
    }

    protected BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(age, 3)));
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos belowPos = blockPos.m_121945_(Direction.DOWN);
        BlockState belowState = levelReader.m_8055_(belowPos);
        return belowState.m_60713_((Block)HopsCropBlock.getHeadBlock()) || belowState.m_60713_((Block)HopsCropBlock.getBodyBlock()) || belowState.m_60713_(Blocks.f_50093_);
    }

    protected boolean canGrow(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)AGE) < 3;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player.m_21120_(interactionHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        int age = (Integer)blockState.m_61143_((Property)AGE);
        if (age > 1) {
            this.dropHops(level, blockPos, blockState);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected void dropHops(Level level, BlockPos blockPos, BlockState blockState) {
        int age = (Integer)blockState.m_61143_((Property)AGE);
        int amount = level.m_213780_().m_188503_(2);
        HopsCropBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.HOPS.get(), amount + (age >= 3 ? 1 : 0)));
        level.m_5594_(null, blockPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    public boolean m_6724_(BlockState blockState) {
        return this.canGrow(blockState);
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int age;
        if (serverLevel.m_45524_(blockPos, 0) >= 9 && (age = ((Integer)blockState.m_61143_((Property)AGE)).intValue()) < 3 && (double)randomSource.m_188501_() < 0.2) {
            serverLevel.m_7731_(blockPos, this.getStateForAge(age + 1), 2);
        }
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return blockState.m_60819_().m_76178_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

