/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn.command;

import com.frikinjay.letmedespawn.LetMeDespawn;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobCategory;

public class LetMeDespawnCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"letmedespawn").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestMobNames).executes(LetMeDespawnCommands::addMob)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestConfiguredMobNames).executes(LetMeDespawnCommands::removeMob))));
    }

    private static CompletableFuture<Suggestions> suggestMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        BuiltInRegistries.f_256780_.forEach(entityType -> {
            if (entityType.m_20674_().equals((Object)MobCategory.MONSTER)) {
                builder.suggest(BuiltInRegistries.f_256780_.m_7981_(entityType).toString());
            }
        });
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestConfiguredMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LetMeDespawn.config.getMobNames().stream().filter(mobName -> mobName.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int addMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Mob '" + mobName + "' is already in the configuration.")).m_130940_(ChatFormatting.RED), false);
        } else {
            LetMeDespawn.config.addMobName(mobName);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Added '" + mobName + "' to LetMeDespawn configuration.")).m_130940_(ChatFormatting.AQUA), true);
        }
        return 1;
    }

    private static int removeMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            LetMeDespawn.config.removeMobName(mobName);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed '" + mobName + "' from LetMeDespawn configuration.")).m_130940_(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Mob '" + mobName + "' is not in the configuration.")).m_130940_(ChatFormatting.RED), false);
        }
        return 1;
    }
}

