/*
 * Decompiled with CFR 0.152.
 */
package net.count.ironsspellsdelight.block.custom;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicProvider;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BloodVialCake
extends CakeBlock {
    private static final Random RANDOM = new Random();
    private static final UUID EMPOWERMENT_UUID = UUID.fromString("6c52b4ba-97b1-4ec6-bc65-abcdef987654");

    public BloodVialCake() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            Optional magicDataOptional = player.getCapability(PlayerMagicProvider.PLAYER_MAGIC).resolve();
            if (magicDataOptional.isEmpty()) {
                player.m_5661_((Component)Component.m_237115_((String)"block.irons_spellbooks.magic_data_error"), true);
                return InteractionResult.FAIL;
            }
            MagicData magicData = (MagicData)magicDataOptional.get();
            if (!player.m_36335_().m_41519_(this.m_5456_())) {
                final AttributeInstance bloodSpellPower = player.m_21051_((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get());
                if (bloodSpellPower != null) {
                    double boostValue = 1.0 + RANDOM.nextDouble() * 1.5;
                    AttributeModifier modifier = new AttributeModifier(EMPOWERMENT_UUID, "Blood Spell Empowerment", boostValue, AttributeModifier.Operation.ADDITION);
                    bloodSpellPower.m_22118_(modifier);
                    player.m_5661_((Component)Component.m_237110_((String)"block.irons_spellbooks.blood_spell_empowered", (Object[])new Object[]{boostValue}), true);
                    MinecraftForge.EVENT_BUS.register(new Object(){
                        private int ticks = 0;

                        @SubscribeEvent
                        public void onTick(TickEvent.ServerTickEvent event) {
                            if (event.phase == TickEvent.Phase.END) {
                                ++this.ticks;
                                if (this.ticks >= 1200) {
                                    bloodSpellPower.m_22120_(EMPOWERMENT_UUID);
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        }
                    });
                }
                player.m_36335_().m_41524_(this.m_5456_(), 1200);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"block.irons_spellbooks.on_cooldown"), true);
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return super.m_5573_(context);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return 0;
    }

    public boolean m_7278_(BlockState state) {
        return false;
    }
}

