/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.ingotcraft.init;

import com.jahirtrap.ingotcraft.init.ModTags;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public enum ModMaterials implements StringRepresentable,
ArmorMaterial
{
    STEEL("steel", 25, ModMaterials.createMap(new int[]{2, 5, 6, 2}), 9, SoundEvents.f_11677_, 1.0f, 0.0f, () -> Ingredient.m_204132_(ModTags.Items.STEEL_INGOTS)),
    BRONZE("bronze", 15, ModMaterials.createMap(new int[]{2, 5, 6, 2}), 16, SoundEvents.f_11676_, 0.0f, 0.0f, () -> Ingredient.m_204132_(ModTags.Items.BRONZE_INGOTS));

    public static final StringRepresentable.EnumCodec<ModMaterials> CODEC;
    private static final EnumMap<ArmorItem.Type, Integer> durability;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> defense;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> ingredient;

    private static EnumMap<ArmorItem.Type, Integer> createMap(int[] values) {
        EnumMap<ArmorItem.Type, Integer> enumMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (int i = 0; i < values.length; ++i) {
            enumMap.put(ArmorItem.Type.values()[i], values[i]);
        }
        return enumMap;
    }

    private ModMaterials(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> ingredient) {
        this.name = new ResourceLocation("ingotcraft", name).toString();
        this.durabilityMultiplier = durabilityMultiplier;
        this.defense = defense;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.ingredient = ingredient;
    }

    public int m_266425_(ArmorItem.Type type) {
        return durability.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.defense.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.ingredient.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.m_216439_(ModMaterials::values);
        durability = ModMaterials.createMap(new int[]{13, 15, 16, 11});
    }
}

