/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.mixins.accessors.BiomeAccessor;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WeatheringHelper {
    public static final Supplier<BiMap<Block, Block>> FLOWERY_BLOCKS = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_152542_, (Object)Blocks.f_152541_).put((Object)Blocks.f_152471_, (Object)Blocks.f_152470_).put((Object)((Block)ModBlocks.LEAF_PILES.get(LeavesTypeRegistry.getValue((ResourceLocation)new ResourceLocation("flowering_azalea")))), (Object)((Block)ModBlocks.LEAF_PILES.get(LeavesTypeRegistry.getValue((ResourceLocation)new ResourceLocation("azalea")))));
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:flowering_azalea_hedge", "quark:azalea_hedge");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:flowering_azalea_leaf_carpet", "quark:azalea_leaf_carpet");
        return builder.build();
    });
    public static final Supplier<Map<Block, LeafPileBlock>> LEAVES_TO_PILES = Suppliers.memoize(() -> {
        ImmutableMap.Builder b = ImmutableMap.builder();
        ModBlocks.LEAF_PILES.forEach((key, value) -> b.put((Object)key.leaves, (Object)value));
        return b.build();
    });
    public static final Supplier<Map<Block, Block>> SOIL_TO_GRASSY = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)ModBlocks.SANDY_DIRT.get(), (Object)ModBlocks.GRASSY_SANDY_DIRT.get()).put((Object)ModBlocks.EARTHEN_CLAY.get(), (Object)ModBlocks.GRASSY_EARTHEN_CLAY.get()).put((Object)ModBlocks.SILT.get(), (Object)ModBlocks.GRASSY_SILT.get()).put((Object)ModBlocks.PERMAFROST.get(), (Object)ModBlocks.GRASSY_PERMAFROST.get()).put((Object)Blocks.f_152549_, (Object)ModBlocks.ROOTED_GRASS_BLOCK.get()).put((Object)Blocks.f_50493_, (Object)Blocks.f_50440_).build());
    public static final Supplier<BiMap<Block, Block>> RAW_TO_STRIPPED = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_220832_, (Object)Blocks.f_220835_).put((Object)Blocks.f_271170_, (Object)Blocks.f_271326_).put((Object)Blocks.f_256831_, (Object)Blocks.f_256740_).put((Object)Blocks.f_50695_, (Object)Blocks.f_50696_).put((Object)Blocks.f_50686_, (Object)Blocks.f_50687_).put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_220836_, (Object)Blocks.f_220837_).put((Object)Blocks.f_271348_, (Object)Blocks.f_271145_).put((Object)Blocks.f_50697_, (Object)Blocks.f_50698_).put((Object)Blocks.f_50688_, (Object)Blocks.f_50689_);
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> STRIPPED_TO_RAW = Suppliers.memoize(() -> RAW_TO_STRIPPED.get().inverse());
    public static final Supplier<BiMap<Block, Item>> WOOD_TO_BARK = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_49999_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("oak")))).put((Object)Blocks.f_50001_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("birch")))).put((Object)Blocks.f_50002_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("jungle")))).put((Object)Blocks.f_50000_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("spruce")))).put((Object)Blocks.f_50003_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("acacia")))).put((Object)Blocks.f_50004_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("dark_oak")))).put((Object)Blocks.f_220832_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("mangrove")))).put((Object)Blocks.f_271170_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("cherry")))).put((Object)Blocks.f_256831_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("bamboo")))).put((Object)Blocks.f_50695_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("crimson")))).put((Object)Blocks.f_50686_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("warped")))).put((Object)Blocks.f_50011_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("oak")))).put((Object)Blocks.f_50013_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("birch")))).put((Object)Blocks.f_50014_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("jungle")))).put((Object)Blocks.f_50012_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("spruce")))).put((Object)Blocks.f_50015_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("acacia")))).put((Object)Blocks.f_50043_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("dark_oak")))).put((Object)Blocks.f_220836_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("mangrove")))).put((Object)Blocks.f_271348_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("cherry")))).put((Object)Blocks.f_50697_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("crimson")))).put((Object)Blocks.f_50688_, (Object)ModItems.BARK.get(WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("warped"))));
        return builder.build();
    });
    public static final Supplier<Map<TagKey<Block>, Block>> WOOD_TO_CHARRED = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)BlockTags.f_13098_, (Object)ModBlocks.CHARRED_FENCE.get()).put((Object)BlockTags.f_13055_, (Object)ModBlocks.CHARRED_FENCE_GATE.get()).put((Object)BlockTags.f_13097_, (Object)ModBlocks.CHARRED_SLAB.get()).put((Object)BlockTags.f_13096_, (Object)ModBlocks.CHARRED_STAIRS.get()).put((Object)BlockTags.f_13090_, (Object)ModBlocks.CHARRED_PLANKS.get()).put((Object)BlockTags.f_13105_, (Object)ModBlocks.CHARRED_LOG.get()).build());

    public static void addOptional(ImmutableBiMap.Builder<Block, Block> map, String moddedId, String moddedId2) {
        Optional o1 = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(moddedId));
        Optional o2 = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((Block)o1.get()), (Object)((Block)o2.get()));
        }
    }

    public static Optional<BlockState> getAzaleaGrowth(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().inverse().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getAzaleaSheared(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getFallenLeafPile(BlockState state) {
        Block b = state.m_60734_();
        if (CommonConfigs.LEAF_PILES_BLACKLIST.get().contains(BuiltInRegistries.f_256975_.m_7981_((Object)b).toString())) {
            return Optional.empty();
        }
        return Optional.ofNullable((Block)LEAVES_TO_PILES.get().get(b));
    }

    @Nullable
    public static Item getBarkToStrip(BlockState normalLog) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)normalLog.m_60734_(), WoodType.class);
        if (woodType != null) {
            boolean log = false;
            String childKey = woodType.getChildKey((Object)normalLog.m_60734_());
            if ("log".equals(childKey) && woodType.getChild("stripped_log") != null || "wood".equals(childKey) && woodType.getChild("stripped_wood") != null) {
                log = true;
            }
            if (log) {
                Optional bark;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty() && (bark = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s))).isPresent()) {
                    return (Item)bark.get();
                }
                return woodType.getItemOfThis("immersive_weathering:bark");
            }
        }
        return null;
    }

    public static Optional<Pair<Item, Block>> getBarkForStrippedLog(BlockState stripped) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)stripped.m_60734_(), WoodType.class);
        if (woodType != null) {
            Object log = null;
            if (woodType.getChild("stripped_log") == stripped.m_60734_()) {
                log = woodType.getChild("log");
            } else if (woodType.getChild("stripped_wood") == stripped.m_60734_()) {
                log = woodType.getChild("wood");
            }
            if (log instanceof Block) {
                Block unStripped = (Block)log;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty()) {
                    Optional bark = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s));
                    if (bark.isPresent()) {
                        return Optional.of(Pair.of((Object)((Item)bark.get()), (Object)unStripped));
                    }
                } else {
                    Item bark = woodType.getItemOfThis("immersive_weathering:bark");
                    if (bark != null) {
                        return Optional.of(Pair.of((Object)bark, (Object)unStripped));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<Pair<Item, Block>> getWoodFromLog(BlockState sourceLog) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)sourceLog.m_60734_(), WoodType.class);
        if (woodType != null) {
            Object log = null;
            if (woodType.getChild("log") == sourceLog.m_60734_()) {
                log = woodType.getChild("wood");
            }
            if (log instanceof Block) {
                Block unStripped = (Block)log;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty()) {
                    Optional bark = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s));
                    if (bark.isPresent()) {
                        return Optional.of(Pair.of((Object)((Item)bark.get()), (Object)unStripped));
                    }
                } else {
                    Item bark = woodType.getItemOfThis("immersive_weathering:bark");
                    if (bark != null) {
                        return Optional.of(Pair.of((Object)bark, (Object)unStripped));
                    }
                }
            }
        }
        return Optional.empty();
    }

    static Optional<Block> getGrassySoil(Block block) {
        return Optional.ofNullable(SOIL_TO_GRASSY.get().get(block));
    }

    public static Optional<BlockState> getGrassySoil(BlockState state) {
        return WeatheringHelper.getGrassySoil(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Item> getBark(Block block) {
        return Optional.ofNullable((Item)WOOD_TO_BARK.get().get((Object)block));
    }

    public static List<BlockPos> grabBlocksAroundRandomly(BlockPos centerPos, int radiusX, int radiusY, int radiusZ) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(BlockPos.m_121985_((BlockPos)centerPos, (int)radiusX, (int)radiusY, (int)radiusZ).map(BlockPos::new).toList());
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        return list;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radiusX, int radiusY, int radiusZ, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        List<BlockPos> lis = WeatheringHelper.grabBlocksAroundRandomly(centerPos, radiusX, radiusY, radiusZ);
        int count = 0;
        for (BlockPos pos : lis) {
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radius, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        return WeatheringHelper.hasEnoughBlocksAround(centerPos, radius, radius, radius, level, blockPredicate, requiredAmount);
    }

    public static boolean hasEnoughBlocksFacingMe(BlockPos centerPos, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        int count = 0;
        ArrayList<Direction> list = new ArrayList<Direction>(List.of(Direction.values()));
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        for (Direction dir : list) {
            BlockPos pos = centerPos.m_121945_(dir);
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) && (!state.m_61138_((Property)RotatedPillarBlock.f_55923_) || state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) && !BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135815_().contains("stripped");
    }

    public static boolean isIciclePos(BlockPos pos) {
        int rarity = CommonConfigs.ICICLE_RARITY.get();
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        if (CommonConfigs.DISABLE_ICICLES.get().booleanValue()) {
            return false;
        }
        return posRandom.nextInt(rarity) == 0;
    }

    public static boolean isRandomWeatheringPos(BlockPos pos) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(6) == 0;
    }

    public static void onFireExpired(ServerLevel serverLevel, BlockPos pos, BlockState state) {
    }

    public static Optional<Block> getCharredBlock(TagKey<Block> block) {
        return Optional.ofNullable(WOOD_TO_CHARRED.get().get(block));
    }

    @Nullable
    public static BlockState getCharredState(BlockState state) {
        Block charred = null;
        if (state.m_204336_(BlockTags.f_13098_)) {
            charred = ModBlocks.CHARRED_FENCE.get();
        } else if (state.m_204336_(BlockTags.f_13055_)) {
            charred = ModBlocks.CHARRED_FENCE_GATE.get();
        } else if (state.m_204336_(BlockTags.f_13097_)) {
            charred = ModBlocks.CHARRED_SLAB.get();
        } else if (state.m_204336_(BlockTags.f_13096_)) {
            charred = ModBlocks.CHARRED_STAIRS.get();
        } else if (state.m_204336_(BlockTags.f_13090_)) {
            charred = ModBlocks.CHARRED_PLANKS.get();
        } else if (state.m_204336_(BlockTags.f_13105_)) {
            charred = ModBlocks.CHARRED_LOG.get();
        }
        if (charred == null) {
            return null;
        }
        return charred.m_152465_(state);
    }

    public boolean ashStuff(BlockState state, Level level, BlockPos pos) {
        BlockState downState = level.m_8055_(pos.m_7495_());
        if (!(level.f_46441_.m_188501_() > 0.2f) && downState.m_60713_(Blocks.f_50440_)) {
            return level.m_46597_(pos.m_7495_(), Blocks.f_50493_.m_49966_());
        }
        return false;
    }

    public static float getTemp(Level level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        return ((BiomeAccessor)biome).invokeGetTemperature(pos);
    }

    public static boolean isPosWet(Level level, Holder<Biome> biome, BlockPos pos) {
        return biome.m_203656_(ModTags.WET);
    }

    public static boolean isPosHot(Level level, Holder<Biome> biome, BlockPos pos) {
        return biome.m_203656_(ModTags.HOT);
    }

    public static void growHangingRoots(ServerLevel level, RandomSource random, BlockPos pos) {
        Direction dir = Direction.values()[1 + random.m_188503_(5)].m_122424_();
        BlockPos targetPos = pos.m_121945_(dir);
        BlockState targetState = level.m_8055_(targetPos);
        FluidState fluidState = level.m_6425_(targetPos);
        boolean bl = fluidState.m_192917_((Fluid)Fluids.f_76193_);
        if (targetState.m_247087_()) {
            BlockState newState = dir == Direction.DOWN ? Blocks.f_152548_.m_49966_() : (BlockState)ModBlocks.HANGING_ROOTS_WALL.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir);
            level.m_46597_(targetPos, (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(bl)));
        }
    }
}

