/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixins;

import com.ordana.immersive_weathering.data.block_growths.BlockGrowthHandler;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    protected ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, Supplier<ProfilerFiller> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;")}, slice={@Slice(from=@At(value="CONSTANT", args={"stringValue=randomTick"}))}, locals=LocalCapture.CAPTURE_FAILHARD, require=1)
    private void IW_weatheringTick(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci, ChunkPos chunkPos, boolean bl, int i, int j, ProfilerFiller profilerFiller, LevelChunkSection[] levelChunkSections, int m, LevelChunkSection levelChunkSection, int k, int n, int l, BlockPos blockPos3, BlockState blockState4) {
        BlockState newState = levelChunkSection.m_62982_(blockPos3.m_123341_() - i, blockPos3.m_123342_() - n, blockPos3.m_123343_() - j);
        BlockGrowthHandler.tickBlock(TickSource.BLOCK_TICK, newState, (ServerLevel)this, blockPos3);
    }

    @Inject(method={"tickChunk"}, require=0, at={@At(value="TAIL")})
    private void precipitationTick(LevelChunk levelChunk, int randomTickSpeed, CallbackInfo ci) {
        ProfilerFiller p = this.m_46473_();
        p.m_6180_("ImmWeatheringExtraRandomTicks");
        BlockGrowthHandler.performSkyAccessTick((ServerLevel)this, levelChunk, randomTickSpeed);
        p.m_7238_();
    }
}

